/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdbelastic.model.SnapshotType;
import software.amazon.awssdk.services.docdbelastic.model.Status;
import software.amazon.awssdk.services.docdbelastic.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSnapshot
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterSnapshot> {
    private static final SdkField<String> ADMIN_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("adminUserName").getter(ClusterSnapshot.getter(ClusterSnapshot::adminUserName)).setter(ClusterSnapshot.setter(Builder::adminUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUserName").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ClusterSnapshot.getter(ClusterSnapshot::clusterArn)).setter(ClusterSnapshot.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterCreationTime").getter(ClusterSnapshot.getter(ClusterSnapshot::clusterCreationTime)).setter(ClusterSnapshot.setter(Builder::clusterCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterCreationTime").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(ClusterSnapshot.getter(ClusterSnapshot::kmsKeyId)).setter(ClusterSnapshot.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotArn").getter(ClusterSnapshot.getter(ClusterSnapshot::snapshotArn)).setter(ClusterSnapshot.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotCreationTime").getter(ClusterSnapshot.getter(ClusterSnapshot::snapshotCreationTime)).setter(ClusterSnapshot.setter(Builder::snapshotCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreationTime").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotName").getter(ClusterSnapshot.getter(ClusterSnapshot::snapshotName)).setter(ClusterSnapshot.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()}).build();
    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotType").getter(ClusterSnapshot.getter(ClusterSnapshot::snapshotTypeAsString)).setter(ClusterSnapshot.setter(Builder::snapshotType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ClusterSnapshot.getter(ClusterSnapshot::statusAsString)).setter(ClusterSnapshot.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(ClusterSnapshot.getter(ClusterSnapshot::subnetIds)).setter(ClusterSnapshot.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroupIds").getter(ClusterSnapshot.getter(ClusterSnapshot::vpcSecurityGroupIds)).setter(ClusterSnapshot.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADMIN_USER_NAME_FIELD, CLUSTER_ARN_FIELD, CLUSTER_CREATION_TIME_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CREATION_TIME_FIELD, SNAPSHOT_NAME_FIELD, SNAPSHOT_TYPE_FIELD, STATUS_FIELD, SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("adminUserName", ADMIN_USER_NAME_FIELD);
            this.put("clusterArn", CLUSTER_ARN_FIELD);
            this.put("clusterCreationTime", CLUSTER_CREATION_TIME_FIELD);
            this.put("kmsKeyId", KMS_KEY_ID_FIELD);
            this.put("snapshotArn", SNAPSHOT_ARN_FIELD);
            this.put("snapshotCreationTime", SNAPSHOT_CREATION_TIME_FIELD);
            this.put("snapshotName", SNAPSHOT_NAME_FIELD);
            this.put("snapshotType", SNAPSHOT_TYPE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("subnetIds", SUBNET_IDS_FIELD);
            this.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String adminUserName;
    private final String clusterArn;
    private final String clusterCreationTime;
    private final String kmsKeyId;
    private final String snapshotArn;
    private final String snapshotCreationTime;
    private final String snapshotName;
    private final String snapshotType;
    private final String status;
    private final List<String> subnetIds;
    private final List<String> vpcSecurityGroupIds;

    private ClusterSnapshot(BuilderImpl builder) {
        this.adminUserName = builder.adminUserName;
        this.clusterArn = builder.clusterArn;
        this.clusterCreationTime = builder.clusterCreationTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotCreationTime = builder.snapshotCreationTime;
        this.snapshotName = builder.snapshotName;
        this.snapshotType = builder.snapshotType;
        this.status = builder.status;
        this.subnetIds = builder.subnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    public final String adminUserName() {
        return this.adminUserName;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterCreationTime() {
        return this.clusterCreationTime;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final String snapshotCreationTime() {
        return this.snapshotCreationTime;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final SnapshotType snapshotType() {
        return SnapshotType.fromValue(this.snapshotType);
    }

    public final String snapshotTypeAsString() {
        return this.snapshotType;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adminUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshot)) {
            return false;
        }
        ClusterSnapshot other = (ClusterSnapshot)obj;
        return Objects.equals(this.adminUserName(), other.adminUserName()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterCreationTime(), other.clusterCreationTime()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && Objects.equals(this.snapshotCreationTime(), other.snapshotCreationTime()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.snapshotTypeAsString(), other.snapshotTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterSnapshot").add("AdminUserName", (Object)this.adminUserName()).add("ClusterArn", (Object)this.clusterArn()).add("ClusterCreationTime", (Object)this.clusterCreationTime()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SnapshotArn", (Object)this.snapshotArn()).add("SnapshotCreationTime", (Object)this.snapshotCreationTime()).add("SnapshotName", (Object)this.snapshotName()).add("SnapshotType", (Object)this.snapshotTypeAsString()).add("Status", (Object)this.statusAsString()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adminUserName": {
                return Optional.ofNullable(clazz.cast(this.adminUserName()));
            }
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "clusterCreationTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreationTime()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "snapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "snapshotCreationTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreationTime()));
            }
            case "snapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "snapshotType": {
                return Optional.ofNullable(clazz.cast(this.snapshotTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "vpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSnapshot, T> g) {
        return obj -> g.apply((ClusterSnapshot)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adminUserName;
        private String clusterArn;
        private String clusterCreationTime;
        private String kmsKeyId;
        private String snapshotArn;
        private String snapshotCreationTime;
        private String snapshotName;
        private String snapshotType;
        private String status;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshot model) {
            this.adminUserName(model.adminUserName);
            this.clusterArn(model.clusterArn);
            this.clusterCreationTime(model.clusterCreationTime);
            this.kmsKeyId(model.kmsKeyId);
            this.snapshotArn(model.snapshotArn);
            this.snapshotCreationTime(model.snapshotCreationTime);
            this.snapshotName(model.snapshotName);
            this.snapshotType(model.snapshotType);
            this.status(model.status);
            this.subnetIds(model.subnetIds);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getAdminUserName() {
            return this.adminUserName;
        }

        public final void setAdminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
        }

        @Override
        public final Builder adminUserName(String adminUserName) {
            this.adminUserName = adminUserName;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterCreationTime() {
            return this.clusterCreationTime;
        }

        public final void setClusterCreationTime(String clusterCreationTime) {
            this.clusterCreationTime = clusterCreationTime;
        }

        @Override
        public final Builder clusterCreationTime(String clusterCreationTime) {
            this.clusterCreationTime = clusterCreationTime;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotCreationTime() {
            return this.snapshotCreationTime;
        }

        public final void setSnapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
        }

        @Override
        public final Builder snapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSnapshotType() {
            return this.snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        @Override
        public final Builder snapshotType(SnapshotType snapshotType) {
            this.snapshotType(snapshotType == null ? null : snapshotType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public ClusterSnapshot build() {
            return new ClusterSnapshot(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterSnapshot> {
        public Builder adminUserName(String var1);

        public Builder clusterArn(String var1);

        public Builder clusterCreationTime(String var1);

        public Builder kmsKeyId(String var1);

        public Builder snapshotArn(String var1);

        public Builder snapshotCreationTime(String var1);

        public Builder snapshotName(String var1);

        public Builder snapshotType(String var1);

        public Builder snapshotType(SnapshotType var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);
    }
}

