/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.Connection;
import software.amazon.awssdk.services.directconnect.model.ConnectionListCopier;
import software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy;
import software.amazon.awssdk.services.directconnect.model.LagState;
import software.amazon.awssdk.services.directconnect.model.MacSecKey;
import software.amazon.awssdk.services.directconnect.model.MacSecKeyListCopier;
import software.amazon.awssdk.services.directconnect.model.Tag;
import software.amazon.awssdk.services.directconnect.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Lag
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Lag> {
    private static final SdkField<String> CONNECTIONS_BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionsBandwidth").getter(Lag.getter(Lag::connectionsBandwidth)).setter(Lag.setter(Builder::connectionsBandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionsBandwidth").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfConnections").getter(Lag.getter(Lag::numberOfConnections)).setter(Lag.setter(Builder::numberOfConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfConnections").build()}).build();
    private static final SdkField<String> LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagId").getter(Lag.getter(Lag::lagId)).setter(Lag.setter(Builder::lagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(Lag.getter(Lag::ownerAccount)).setter(Lag.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> LAG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagName").getter(Lag.getter(Lag::lagName)).setter(Lag.setter(Builder::lagName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagName").build()}).build();
    private static final SdkField<String> LAG_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagState").getter(Lag.getter(Lag::lagStateAsString)).setter(Lag.setter(Builder::lagState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagState").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(Lag.getter(Lag::location)).setter(Lag.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Lag.getter(Lag::region)).setter(Lag.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<Integer> MINIMUM_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumLinks").getter(Lag.getter(Lag::minimumLinks)).setter(Lag.setter(Builder::minimumLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLinks").build()}).build();
    private static final SdkField<String> AWS_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDevice").getter(Lag.getter(Lag::awsDevice)).setter(Lag.setter(Builder::awsDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDevice").build()}).build();
    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsDeviceV2").getter(Lag.getter(Lag::awsDeviceV2)).setter(Lag.setter(Builder::awsDeviceV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()}).build();
    private static final SdkField<String> AWS_LOGICAL_DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsLogicalDeviceId").getter(Lag.getter(Lag::awsLogicalDeviceId)).setter(Lag.setter(Builder::awsLogicalDeviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsLogicalDeviceId").build()}).build();
    private static final SdkField<List<Connection>> CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("connections").getter(Lag.getter(Lag::connections)).setter(Lag.setter(Builder::connections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Connection::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOWS_HOSTED_CONNECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowsHostedConnections").getter(Lag.getter(Lag::allowsHostedConnections)).setter(Lag.setter(Builder::allowsHostedConnections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowsHostedConnections").build()}).build();
    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("jumboFrameCapable").getter(Lag.getter(Lag::jumboFrameCapable)).setter(Lag.setter(Builder::jumboFrameCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()}).build();
    private static final SdkField<String> HAS_LOGICAL_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hasLogicalRedundancy").getter(Lag.getter(Lag::hasLogicalRedundancyAsString)).setter(Lag.setter(Builder::hasLogicalRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasLogicalRedundancy").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Lag.getter(Lag::tags)).setter(Lag.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(Lag.getter(Lag::providerName)).setter(Lag.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<Boolean> MAC_SEC_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("macSecCapable").getter(Lag.getter(Lag::macSecCapable)).setter(Lag.setter(Builder::macSecCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecCapable").build()}).build();
    private static final SdkField<String> ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionMode").getter(Lag.getter(Lag::encryptionMode)).setter(Lag.setter(Builder::encryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionMode").build()}).build();
    private static final SdkField<List<MacSecKey>> MAC_SEC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("macSecKeys").getter(Lag.getter(Lag::macSecKeys)).setter(Lag.setter(Builder::macSecKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("macSecKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MacSecKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_BANDWIDTH_FIELD, NUMBER_OF_CONNECTIONS_FIELD, LAG_ID_FIELD, OWNER_ACCOUNT_FIELD, LAG_NAME_FIELD, LAG_STATE_FIELD, LOCATION_FIELD, REGION_FIELD, MINIMUM_LINKS_FIELD, AWS_DEVICE_FIELD, AWS_DEVICE_V2_FIELD, AWS_LOGICAL_DEVICE_ID_FIELD, CONNECTIONS_FIELD, ALLOWS_HOSTED_CONNECTIONS_FIELD, JUMBO_FRAME_CAPABLE_FIELD, HAS_LOGICAL_REDUNDANCY_FIELD, TAGS_FIELD, PROVIDER_NAME_FIELD, MAC_SEC_CAPABLE_FIELD, ENCRYPTION_MODE_FIELD, MAC_SEC_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("connectionsBandwidth", CONNECTIONS_BANDWIDTH_FIELD);
            this.put("numberOfConnections", NUMBER_OF_CONNECTIONS_FIELD);
            this.put("lagId", LAG_ID_FIELD);
            this.put("ownerAccount", OWNER_ACCOUNT_FIELD);
            this.put("lagName", LAG_NAME_FIELD);
            this.put("lagState", LAG_STATE_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("region", REGION_FIELD);
            this.put("minimumLinks", MINIMUM_LINKS_FIELD);
            this.put("awsDevice", AWS_DEVICE_FIELD);
            this.put("awsDeviceV2", AWS_DEVICE_V2_FIELD);
            this.put("awsLogicalDeviceId", AWS_LOGICAL_DEVICE_ID_FIELD);
            this.put("connections", CONNECTIONS_FIELD);
            this.put("allowsHostedConnections", ALLOWS_HOSTED_CONNECTIONS_FIELD);
            this.put("jumboFrameCapable", JUMBO_FRAME_CAPABLE_FIELD);
            this.put("hasLogicalRedundancy", HAS_LOGICAL_REDUNDANCY_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("providerName", PROVIDER_NAME_FIELD);
            this.put("macSecCapable", MAC_SEC_CAPABLE_FIELD);
            this.put("encryptionMode", ENCRYPTION_MODE_FIELD);
            this.put("macSecKeys", MAC_SEC_KEYS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String connectionsBandwidth;
    private final Integer numberOfConnections;
    private final String lagId;
    private final String ownerAccount;
    private final String lagName;
    private final String lagState;
    private final String location;
    private final String region;
    private final Integer minimumLinks;
    private final String awsDevice;
    private final String awsDeviceV2;
    private final String awsLogicalDeviceId;
    private final List<Connection> connections;
    private final Boolean allowsHostedConnections;
    private final Boolean jumboFrameCapable;
    private final String hasLogicalRedundancy;
    private final List<Tag> tags;
    private final String providerName;
    private final Boolean macSecCapable;
    private final String encryptionMode;
    private final List<MacSecKey> macSecKeys;

    private Lag(BuilderImpl builder) {
        this.connectionsBandwidth = builder.connectionsBandwidth;
        this.numberOfConnections = builder.numberOfConnections;
        this.lagId = builder.lagId;
        this.ownerAccount = builder.ownerAccount;
        this.lagName = builder.lagName;
        this.lagState = builder.lagState;
        this.location = builder.location;
        this.region = builder.region;
        this.minimumLinks = builder.minimumLinks;
        this.awsDevice = builder.awsDevice;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.awsLogicalDeviceId = builder.awsLogicalDeviceId;
        this.connections = builder.connections;
        this.allowsHostedConnections = builder.allowsHostedConnections;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.hasLogicalRedundancy = builder.hasLogicalRedundancy;
        this.tags = builder.tags;
        this.providerName = builder.providerName;
        this.macSecCapable = builder.macSecCapable;
        this.encryptionMode = builder.encryptionMode;
        this.macSecKeys = builder.macSecKeys;
    }

    public final String connectionsBandwidth() {
        return this.connectionsBandwidth;
    }

    public final Integer numberOfConnections() {
        return this.numberOfConnections;
    }

    public final String lagId() {
        return this.lagId;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final String lagName() {
        return this.lagName;
    }

    public final LagState lagState() {
        return LagState.fromValue(this.lagState);
    }

    public final String lagStateAsString() {
        return this.lagState;
    }

    public final String location() {
        return this.location;
    }

    public final String region() {
        return this.region;
    }

    public final Integer minimumLinks() {
        return this.minimumLinks;
    }

    public final String awsDevice() {
        return this.awsDevice;
    }

    public final String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public final String awsLogicalDeviceId() {
        return this.awsLogicalDeviceId;
    }

    public final boolean hasConnections() {
        return this.connections != null && !(this.connections instanceof SdkAutoConstructList);
    }

    public final List<Connection> connections() {
        return this.connections;
    }

    public final Boolean allowsHostedConnections() {
        return this.allowsHostedConnections;
    }

    public final Boolean jumboFrameCapable() {
        return this.jumboFrameCapable;
    }

    public final HasLogicalRedundancy hasLogicalRedundancy() {
        return HasLogicalRedundancy.fromValue(this.hasLogicalRedundancy);
    }

    public final String hasLogicalRedundancyAsString() {
        return this.hasLogicalRedundancy;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final Boolean macSecCapable() {
        return this.macSecCapable;
    }

    public final String encryptionMode() {
        return this.encryptionMode;
    }

    public final boolean hasMacSecKeys() {
        return this.macSecKeys != null && !(this.macSecKeys instanceof SdkAutoConstructList);
    }

    public final List<MacSecKey> macSecKeys() {
        return this.macSecKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionsBandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsLogicalDeviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnections() ? this.connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowsHostedConnections());
        hashCode = 31 * hashCode + Objects.hashCode(this.jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalRedundancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.macSecCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMacSecKeys() ? this.macSecKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Lag)) {
            return false;
        }
        Lag other = (Lag)obj;
        return Objects.equals(this.connectionsBandwidth(), other.connectionsBandwidth()) && Objects.equals(this.numberOfConnections(), other.numberOfConnections()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.lagName(), other.lagName()) && Objects.equals(this.lagStateAsString(), other.lagStateAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.minimumLinks(), other.minimumLinks()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2()) && Objects.equals(this.awsLogicalDeviceId(), other.awsLogicalDeviceId()) && this.hasConnections() == other.hasConnections() && Objects.equals(this.connections(), other.connections()) && Objects.equals(this.allowsHostedConnections(), other.allowsHostedConnections()) && Objects.equals(this.jumboFrameCapable(), other.jumboFrameCapable()) && Objects.equals(this.hasLogicalRedundancyAsString(), other.hasLogicalRedundancyAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.macSecCapable(), other.macSecCapable()) && Objects.equals(this.encryptionMode(), other.encryptionMode()) && this.hasMacSecKeys() == other.hasMacSecKeys() && Objects.equals(this.macSecKeys(), other.macSecKeys());
    }

    public final String toString() {
        return ToString.builder((String)"Lag").add("ConnectionsBandwidth", (Object)this.connectionsBandwidth()).add("NumberOfConnections", (Object)this.numberOfConnections()).add("LagId", (Object)this.lagId()).add("OwnerAccount", (Object)this.ownerAccount()).add("LagName", (Object)this.lagName()).add("LagState", (Object)this.lagStateAsString()).add("Location", (Object)this.location()).add("Region", (Object)this.region()).add("MinimumLinks", (Object)this.minimumLinks()).add("AwsDevice", (Object)this.awsDevice()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).add("AwsLogicalDeviceId", (Object)this.awsLogicalDeviceId()).add("Connections", this.hasConnections() ? this.connections() : null).add("AllowsHostedConnections", (Object)this.allowsHostedConnections()).add("JumboFrameCapable", (Object)this.jumboFrameCapable()).add("HasLogicalRedundancy", (Object)this.hasLogicalRedundancyAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ProviderName", (Object)this.providerName()).add("MacSecCapable", (Object)this.macSecCapable()).add("EncryptionMode", (Object)this.encryptionMode()).add("MacSecKeys", this.hasMacSecKeys() ? this.macSecKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionsBandwidth": {
                return Optional.ofNullable(clazz.cast(this.connectionsBandwidth()));
            }
            case "numberOfConnections": {
                return Optional.ofNullable(clazz.cast(this.numberOfConnections()));
            }
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "lagName": {
                return Optional.ofNullable(clazz.cast(this.lagName()));
            }
            case "lagState": {
                return Optional.ofNullable(clazz.cast(this.lagStateAsString()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "minimumLinks": {
                return Optional.ofNullable(clazz.cast(this.minimumLinks()));
            }
            case "awsDevice": {
                return Optional.ofNullable(clazz.cast(this.awsDevice()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
            case "awsLogicalDeviceId": {
                return Optional.ofNullable(clazz.cast(this.awsLogicalDeviceId()));
            }
            case "connections": {
                return Optional.ofNullable(clazz.cast(this.connections()));
            }
            case "allowsHostedConnections": {
                return Optional.ofNullable(clazz.cast(this.allowsHostedConnections()));
            }
            case "jumboFrameCapable": {
                return Optional.ofNullable(clazz.cast(this.jumboFrameCapable()));
            }
            case "hasLogicalRedundancy": {
                return Optional.ofNullable(clazz.cast(this.hasLogicalRedundancyAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "macSecCapable": {
                return Optional.ofNullable(clazz.cast(this.macSecCapable()));
            }
            case "encryptionMode": {
                return Optional.ofNullable(clazz.cast(this.encryptionMode()));
            }
            case "macSecKeys": {
                return Optional.ofNullable(clazz.cast(this.macSecKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Lag, T> g) {
        return obj -> g.apply((Lag)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectionsBandwidth;
        private Integer numberOfConnections;
        private String lagId;
        private String ownerAccount;
        private String lagName;
        private String lagState;
        private String location;
        private String region;
        private Integer minimumLinks;
        private String awsDevice;
        private String awsDeviceV2;
        private String awsLogicalDeviceId;
        private List<Connection> connections = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowsHostedConnections;
        private Boolean jumboFrameCapable;
        private String hasLogicalRedundancy;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String providerName;
        private Boolean macSecCapable;
        private String encryptionMode;
        private List<MacSecKey> macSecKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Lag model) {
            this.connectionsBandwidth(model.connectionsBandwidth);
            this.numberOfConnections(model.numberOfConnections);
            this.lagId(model.lagId);
            this.ownerAccount(model.ownerAccount);
            this.lagName(model.lagName);
            this.lagState(model.lagState);
            this.location(model.location);
            this.region(model.region);
            this.minimumLinks(model.minimumLinks);
            this.awsDevice(model.awsDevice);
            this.awsDeviceV2(model.awsDeviceV2);
            this.awsLogicalDeviceId(model.awsLogicalDeviceId);
            this.connections(model.connections);
            this.allowsHostedConnections(model.allowsHostedConnections);
            this.jumboFrameCapable(model.jumboFrameCapable);
            this.hasLogicalRedundancy(model.hasLogicalRedundancy);
            this.tags(model.tags);
            this.providerName(model.providerName);
            this.macSecCapable(model.macSecCapable);
            this.encryptionMode(model.encryptionMode);
            this.macSecKeys(model.macSecKeys);
        }

        public final String getConnectionsBandwidth() {
            return this.connectionsBandwidth;
        }

        public final void setConnectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
        }

        @Override
        public final Builder connectionsBandwidth(String connectionsBandwidth) {
            this.connectionsBandwidth = connectionsBandwidth;
            return this;
        }

        public final Integer getNumberOfConnections() {
            return this.numberOfConnections;
        }

        public final void setNumberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
        }

        @Override
        public final Builder numberOfConnections(Integer numberOfConnections) {
            this.numberOfConnections = numberOfConnections;
            return this;
        }

        public final String getLagId() {
            return this.lagId;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getLagName() {
            return this.lagName;
        }

        public final void setLagName(String lagName) {
            this.lagName = lagName;
        }

        @Override
        public final Builder lagName(String lagName) {
            this.lagName = lagName;
            return this;
        }

        public final String getLagState() {
            return this.lagState;
        }

        public final void setLagState(String lagState) {
            this.lagState = lagState;
        }

        @Override
        public final Builder lagState(String lagState) {
            this.lagState = lagState;
            return this;
        }

        @Override
        public final Builder lagState(LagState lagState) {
            this.lagState(lagState == null ? null : lagState.toString());
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Integer getMinimumLinks() {
            return this.minimumLinks;
        }

        public final void setMinimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
        }

        @Override
        public final Builder minimumLinks(Integer minimumLinks) {
            this.minimumLinks = minimumLinks;
            return this;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final String getAwsLogicalDeviceId() {
            return this.awsLogicalDeviceId;
        }

        public final void setAwsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
        }

        @Override
        public final Builder awsLogicalDeviceId(String awsLogicalDeviceId) {
            this.awsLogicalDeviceId = awsLogicalDeviceId;
            return this;
        }

        public final List<Connection.Builder> getConnections() {
            List<Connection.Builder> result = ConnectionListCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<Connection.BuilderImpl> connections) {
            this.connections = ConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<Connection> connections) {
            this.connections = ConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Connection ... connections) {
            this.connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<Connection.Builder> ... connections) {
            this.connections(Stream.of(connections).map(c -> (Connection)((Connection.Builder)Connection.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAllowsHostedConnections() {
            return this.allowsHostedConnections;
        }

        public final void setAllowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
        }

        @Override
        public final Builder allowsHostedConnections(Boolean allowsHostedConnections) {
            this.allowsHostedConnections = allowsHostedConnections;
            return this;
        }

        public final Boolean getJumboFrameCapable() {
            return this.jumboFrameCapable;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final String getHasLogicalRedundancy() {
            return this.hasLogicalRedundancy;
        }

        public final void setHasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
        }

        @Override
        public final Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        @Override
        public final Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy) {
            this.hasLogicalRedundancy(hasLogicalRedundancy == null ? null : hasLogicalRedundancy.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final Boolean getMacSecCapable() {
            return this.macSecCapable;
        }

        public final void setMacSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
        }

        @Override
        public final Builder macSecCapable(Boolean macSecCapable) {
            this.macSecCapable = macSecCapable;
            return this;
        }

        public final String getEncryptionMode() {
            return this.encryptionMode;
        }

        public final void setEncryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
        }

        @Override
        public final Builder encryptionMode(String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        public final List<MacSecKey.Builder> getMacSecKeys() {
            List<MacSecKey.Builder> result = MacSecKeyListCopier.copyToBuilder(this.macSecKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMacSecKeys(Collection<MacSecKey.BuilderImpl> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copyFromBuilder(macSecKeys);
        }

        @Override
        public final Builder macSecKeys(Collection<MacSecKey> macSecKeys) {
            this.macSecKeys = MacSecKeyListCopier.copy(macSecKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(MacSecKey ... macSecKeys) {
            this.macSecKeys(Arrays.asList(macSecKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macSecKeys(Consumer<MacSecKey.Builder> ... macSecKeys) {
            this.macSecKeys(Stream.of(macSecKeys).map(c -> (MacSecKey)((MacSecKey.Builder)MacSecKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Lag build() {
            return new Lag(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Lag> {
        public Builder connectionsBandwidth(String var1);

        public Builder numberOfConnections(Integer var1);

        public Builder lagId(String var1);

        public Builder ownerAccount(String var1);

        public Builder lagName(String var1);

        public Builder lagState(String var1);

        public Builder lagState(LagState var1);

        public Builder location(String var1);

        public Builder region(String var1);

        public Builder minimumLinks(Integer var1);

        public Builder awsDevice(String var1);

        public Builder awsDeviceV2(String var1);

        public Builder awsLogicalDeviceId(String var1);

        public Builder connections(Collection<Connection> var1);

        public Builder connections(Connection ... var1);

        public Builder connections(Consumer<Connection.Builder> ... var1);

        public Builder allowsHostedConnections(Boolean var1);

        public Builder jumboFrameCapable(Boolean var1);

        public Builder hasLogicalRedundancy(String var1);

        public Builder hasLogicalRedundancy(HasLogicalRedundancy var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder providerName(String var1);

        public Builder macSecCapable(Boolean var1);

        public Builder encryptionMode(String var1);

        public Builder macSecKeys(Collection<MacSecKey> var1);

        public Builder macSecKeys(MacSecKey ... var1);

        public Builder macSecKeys(Consumer<MacSecKey.Builder> ... var1);
    }
}

