/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruRequest;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsAccountIdListCopier;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsOrganizationalUnitIdListCopier;
import software.amazon.awssdk.services.devopsguru.model.ListInsightsStatusFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationInsightsRequest
extends DevOpsGuruRequest
implements ToCopyableBuilder<Builder, ListOrganizationInsightsRequest> {
    private static final SdkField<ListInsightsStatusFilter> STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatusFilter").getter(ListOrganizationInsightsRequest.getter(ListOrganizationInsightsRequest::statusFilter)).setter(ListOrganizationInsightsRequest.setter(Builder::statusFilter)).constructor(ListInsightsStatusFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilter").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListOrganizationInsightsRequest.getter(ListOrganizationInsightsRequest::maxResults)).setter(ListOrganizationInsightsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<List<String>> ACCOUNT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccountIds").getter(ListOrganizationInsightsRequest.getter(ListOrganizationInsightsRequest::accountIds)).setter(ListOrganizationInsightsRequest.setter(Builder::accountIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnitIds").getter(ListOrganizationInsightsRequest.getter(ListOrganizationInsightsRequest::organizationalUnitIds)).setter(ListOrganizationInsightsRequest.setter(Builder::organizationalUnitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOrganizationInsightsRequest.getter(ListOrganizationInsightsRequest::nextToken)).setter(ListOrganizationInsightsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FILTER_FIELD, MAX_RESULTS_FIELD, ACCOUNT_IDS_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StatusFilter", STATUS_FILTER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("AccountIds", ACCOUNT_IDS_FIELD);
            this.put("OrganizationalUnitIds", ORGANIZATIONAL_UNIT_IDS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final ListInsightsStatusFilter statusFilter;
    private final Integer maxResults;
    private final List<String> accountIds;
    private final List<String> organizationalUnitIds;
    private final String nextToken;

    private ListOrganizationInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.statusFilter = builder.statusFilter;
        this.maxResults = builder.maxResults;
        this.accountIds = builder.accountIds;
        this.organizationalUnitIds = builder.organizationalUnitIds;
        this.nextToken = builder.nextToken;
    }

    public final ListInsightsStatusFilter statusFilter() {
        return this.statusFilter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasAccountIds() {
        return this.accountIds != null && !(this.accountIds instanceof SdkAutoConstructList);
    }

    public final List<String> accountIds() {
        return this.accountIds;
    }

    public final boolean hasOrganizationalUnitIds() {
        return this.organizationalUnitIds != null && !(this.organizationalUnitIds instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitIds() {
        return this.organizationalUnitIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccountIds() ? this.accountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationInsightsRequest)) {
            return false;
        }
        ListOrganizationInsightsRequest other = (ListOrganizationInsightsRequest)((Object)obj);
        return Objects.equals(this.statusFilter(), other.statusFilter()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasAccountIds() == other.hasAccountIds() && Objects.equals(this.accountIds(), other.accountIds()) && this.hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds() && Objects.equals(this.organizationalUnitIds(), other.organizationalUnitIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationInsightsRequest").add("StatusFilter", (Object)this.statusFilter()).add("MaxResults", (Object)this.maxResults()).add("AccountIds", this.hasAccountIds() ? this.accountIds() : null).add("OrganizationalUnitIds", this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusFilter": {
                return Optional.ofNullable(clazz.cast(this.statusFilter()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "AccountIds": {
                return Optional.ofNullable(clazz.cast(this.accountIds()));
            }
            case "OrganizationalUnitIds": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationInsightsRequest, T> g) {
        return obj -> g.apply((ListOrganizationInsightsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruRequest.BuilderImpl
    implements Builder {
        private ListInsightsStatusFilter statusFilter;
        private Integer maxResults;
        private List<String> accountIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationInsightsRequest model) {
            super(model);
            this.statusFilter(model.statusFilter);
            this.maxResults(model.maxResults);
            this.accountIds(model.accountIds);
            this.organizationalUnitIds(model.organizationalUnitIds);
            this.nextToken(model.nextToken);
        }

        public final ListInsightsStatusFilter.Builder getStatusFilter() {
            return this.statusFilter != null ? this.statusFilter.toBuilder() : null;
        }

        public final void setStatusFilter(ListInsightsStatusFilter.BuilderImpl statusFilter) {
            this.statusFilter = statusFilter != null ? statusFilter.build() : null;
        }

        @Override
        public final Builder statusFilter(ListInsightsStatusFilter statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getAccountIds() {
            if (this.accountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accountIds;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = ListInsightsAccountIdListCopier.copy(accountIds);
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = ListInsightsAccountIdListCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (this.organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitIds;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = ListInsightsOrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = ListInsightsOrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String ... organizationalUnitIds) {
            this.organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOrganizationInsightsRequest build() {
            return new ListOrganizationInsightsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationInsightsRequest> {
        public Builder statusFilter(ListInsightsStatusFilter var1);

        default public Builder statusFilter(Consumer<ListInsightsStatusFilter.Builder> statusFilter) {
            return this.statusFilter((ListInsightsStatusFilter)((ListInsightsStatusFilter.Builder)ListInsightsStatusFilter.builder().applyMutation(statusFilter)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder organizationalUnitIds(Collection<String> var1);

        public Builder organizationalUnitIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

