/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.DevOpsGuruResponse;
import software.amazon.awssdk.services.devopsguru.model.ServiceIntegrationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceIntegrationResponse
extends DevOpsGuruResponse
implements ToCopyableBuilder<Builder, DescribeServiceIntegrationResponse> {
    private static final SdkField<ServiceIntegrationConfig> SERVICE_INTEGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceIntegration").getter(DescribeServiceIntegrationResponse.getter(DescribeServiceIntegrationResponse::serviceIntegration)).setter(DescribeServiceIntegrationResponse.setter(Builder::serviceIntegration)).constructor(ServiceIntegrationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIntegration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_INTEGRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServiceIntegration", SERVICE_INTEGRATION_FIELD);
        }
    });
    private final ServiceIntegrationConfig serviceIntegration;

    private DescribeServiceIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.serviceIntegration = builder.serviceIntegration;
    }

    public final ServiceIntegrationConfig serviceIntegration() {
        return this.serviceIntegration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceIntegration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceIntegrationResponse)) {
            return false;
        }
        DescribeServiceIntegrationResponse other = (DescribeServiceIntegrationResponse)((Object)obj);
        return Objects.equals(this.serviceIntegration(), other.serviceIntegration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceIntegrationResponse").add("ServiceIntegration", (Object)this.serviceIntegration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceIntegration": {
                return Optional.ofNullable(clazz.cast(this.serviceIntegration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceIntegrationResponse, T> g) {
        return obj -> g.apply((DescribeServiceIntegrationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DevOpsGuruResponse.BuilderImpl
    implements Builder {
        private ServiceIntegrationConfig serviceIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceIntegrationResponse model) {
            super(model);
            this.serviceIntegration(model.serviceIntegration);
        }

        public final ServiceIntegrationConfig.Builder getServiceIntegration() {
            return this.serviceIntegration != null ? this.serviceIntegration.toBuilder() : null;
        }

        public final void setServiceIntegration(ServiceIntegrationConfig.BuilderImpl serviceIntegration) {
            this.serviceIntegration = serviceIntegration != null ? serviceIntegration.build() : null;
        }

        @Override
        public final Builder serviceIntegration(ServiceIntegrationConfig serviceIntegration) {
            this.serviceIntegration = serviceIntegration;
            return this;
        }

        @Override
        public DescribeServiceIntegrationResponse build() {
            return new DescribeServiceIntegrationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DevOpsGuruResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceIntegrationResponse> {
        public Builder serviceIntegration(ServiceIntegrationConfig var1);

        default public Builder serviceIntegration(Consumer<ServiceIntegrationConfig.Builder> serviceIntegration) {
            return this.serviceIntegration((ServiceIntegrationConfig)((ServiceIntegrationConfig.Builder)ServiceIntegrationConfig.builder().applyMutation(serviceIntegration)).build());
        }
    }
}

