/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmResponse;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfile;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNetworkProfilesResponse
extends DeviceFarmResponse
implements ToCopyableBuilder<Builder, ListNetworkProfilesResponse> {
    private static final SdkField<List<NetworkProfile>> NETWORK_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkProfiles").getter(ListNetworkProfilesResponse.getter(ListNetworkProfilesResponse::networkProfiles)).setter(ListNetworkProfilesResponse.setter(Builder::networkProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNetworkProfilesResponse.getter(ListNetworkProfilesResponse::nextToken)).setter(ListNetworkProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PROFILES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("networkProfiles", NETWORK_PROFILES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<NetworkProfile> networkProfiles;
    private final String nextToken;

    private ListNetworkProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.networkProfiles = builder.networkProfiles;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkProfiles() {
        return this.networkProfiles != null && !(this.networkProfiles instanceof SdkAutoConstructList);
    }

    public final List<NetworkProfile> networkProfiles() {
        return this.networkProfiles;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkProfiles() ? this.networkProfiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkProfilesResponse)) {
            return false;
        }
        ListNetworkProfilesResponse other = (ListNetworkProfilesResponse)((Object)obj);
        return this.hasNetworkProfiles() == other.hasNetworkProfiles() && Objects.equals(this.networkProfiles(), other.networkProfiles()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNetworkProfilesResponse").add("NetworkProfiles", this.hasNetworkProfiles() ? this.networkProfiles() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkProfiles": {
                return Optional.ofNullable(clazz.cast(this.networkProfiles()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkProfilesResponse, T> g) {
        return obj -> g.apply((ListNetworkProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmResponse.BuilderImpl
    implements Builder {
        private List<NetworkProfile> networkProfiles = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkProfilesResponse model) {
            super(model);
            this.networkProfiles(model.networkProfiles);
            this.nextToken(model.nextToken);
        }

        public final List<NetworkProfile.Builder> getNetworkProfiles() {
            List<NetworkProfile.Builder> result = NetworkProfilesCopier.copyToBuilder(this.networkProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkProfiles(Collection<NetworkProfile.BuilderImpl> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copyFromBuilder(networkProfiles);
        }

        @Override
        public final Builder networkProfiles(Collection<NetworkProfile> networkProfiles) {
            this.networkProfiles = NetworkProfilesCopier.copy(networkProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(NetworkProfile ... networkProfiles) {
            this.networkProfiles(Arrays.asList(networkProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkProfiles(Consumer<NetworkProfile.Builder> ... networkProfiles) {
            this.networkProfiles(Stream.of(networkProfiles).map(c -> (NetworkProfile)((NetworkProfile.Builder)NetworkProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNetworkProfilesResponse build() {
            return new ListNetworkProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeviceFarmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNetworkProfilesResponse> {
        public Builder networkProfiles(Collection<NetworkProfile> var1);

        public Builder networkProfiles(NetworkProfile ... var1);

        public Builder networkProfiles(Consumer<NetworkProfile.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

