/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.detective.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IndicatorType {
    TTP_OBSERVED("TTP_OBSERVED"),
    IMPOSSIBLE_TRAVEL("IMPOSSIBLE_TRAVEL"),
    FLAGGED_IP_ADDRESS("FLAGGED_IP_ADDRESS"),
    NEW_GEOLOCATION("NEW_GEOLOCATION"),
    NEW_ASO("NEW_ASO"),
    NEW_USER_AGENT("NEW_USER_AGENT"),
    RELATED_FINDING("RELATED_FINDING"),
    RELATED_FINDING_GROUP("RELATED_FINDING_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IndicatorType> VALUE_MAP;
    private final String value;

    private IndicatorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IndicatorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IndicatorType> knownValues() {
        EnumSet<IndicatorType> knownValues = EnumSet.allOf(IndicatorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IndicatorType.class, IndicatorType::toString);
    }
}

