/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter;
import software.amazon.awssdk.services.datasync.model.DiscoveryResourceType;
import software.amazon.awssdk.services.datasync.model.ResourceFiltersCopier;
import software.amazon.awssdk.services.datasync.model.ResourceIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStorageSystemResourcesRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, DescribeStorageSystemResourcesRequest> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryJobArn").getter(DescribeStorageSystemResourcesRequest.getter(DescribeStorageSystemResourcesRequest::discoveryJobArn)).setter(DescribeStorageSystemResourcesRequest.setter(Builder::discoveryJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(DescribeStorageSystemResourcesRequest.getter(DescribeStorageSystemResourcesRequest::resourceTypeAsString)).setter(DescribeStorageSystemResourcesRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIds").getter(DescribeStorageSystemResourcesRequest.getter(DescribeStorageSystemResourcesRequest::resourceIds)).setter(DescribeStorageSystemResourcesRequest.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Filter").getter(DescribeStorageSystemResourcesRequest.getter(DescribeStorageSystemResourcesRequest::filterAsStrings)).setter(DescribeStorageSystemResourcesRequest.setter(Builder::filterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeStorageSystemResourcesRequest.getter(DescribeStorageSystemResourcesRequest::maxResults)).setter(DescribeStorageSystemResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStorageSystemResourcesRequest.getter(DescribeStorageSystemResourcesRequest::nextToken)).setter(DescribeStorageSystemResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_IDS_FIELD, FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DiscoveryJobArn", DISCOVERY_JOB_ARN_FIELD);
            this.put("ResourceType", RESOURCE_TYPE_FIELD);
            this.put("ResourceIds", RESOURCE_IDS_FIELD);
            this.put("Filter", FILTER_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String discoveryJobArn;
    private final String resourceType;
    private final List<String> resourceIds;
    private final Map<String, List<String>> filter;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeStorageSystemResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.discoveryJobArn = builder.discoveryJobArn;
        this.resourceType = builder.resourceType;
        this.resourceIds = builder.resourceIds;
        this.filter = builder.filter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String discoveryJobArn() {
        return this.discoveryJobArn;
    }

    public final DiscoveryResourceType resourceType() {
        return DiscoveryResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIds() {
        return this.resourceIds;
    }

    public final Map<DiscoveryResourceFilter, List<String>> filter() {
        return ResourceFiltersCopier.copyStringToEnum(this.filter);
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> filterAsStrings() {
        return this.filter;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorageSystemResourcesRequest)) {
            return false;
        }
        DescribeStorageSystemResourcesRequest other = (DescribeStorageSystemResourcesRequest)((Object)obj);
        return Objects.equals(this.discoveryJobArn(), other.discoveryJobArn()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && this.hasFilter() == other.hasFilter() && Objects.equals(this.filterAsStrings(), other.filterAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStorageSystemResourcesRequest").add("DiscoveryJobArn", (Object)this.discoveryJobArn()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("Filter", this.hasFilter() ? this.filterAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiscoveryJobArn": {
                return Optional.ofNullable(clazz.cast(this.discoveryJobArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ResourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filterAsStrings()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorageSystemResourcesRequest, T> g) {
        return obj -> g.apply((DescribeStorageSystemResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String discoveryJobArn;
        private String resourceType;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<String>> filter = DefaultSdkAutoConstructMap.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorageSystemResourcesRequest model) {
            super(model);
            this.discoveryJobArn(model.discoveryJobArn);
            this.resourceType(model.resourceType);
            this.resourceIds(model.resourceIds);
            this.filterWithStrings(model.filter);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getDiscoveryJobArn() {
            return this.discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(DiscoveryResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (this.resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsCopier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ResourceIdsCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final Map<String, ? extends Collection<String>> getFilter() {
            if (this.filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filter;
        }

        public final void setFilter(Map<String, ? extends Collection<String>> filter) {
            this.filter = ResourceFiltersCopier.copy(filter);
        }

        @Override
        public final Builder filterWithStrings(Map<String, ? extends Collection<String>> filter) {
            this.filter = ResourceFiltersCopier.copy(filter);
            return this;
        }

        @Override
        public final Builder filter(Map<DiscoveryResourceFilter, ? extends Collection<String>> filter) {
            this.filter = ResourceFiltersCopier.copyEnumToString(filter);
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStorageSystemResourcesRequest build() {
            return new DescribeStorageSystemResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStorageSystemResourcesRequest> {
        public Builder discoveryJobArn(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(DiscoveryResourceType var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder filterWithStrings(Map<String, ? extends Collection<String>> var1);

        public Builder filter(Map<DiscoveryResourceFilter, ? extends Collection<String>> var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

