/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeAsyncClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.DataGrantSummaryEntry;
import software.amazon.awssdk.services.dataexchange.model.ListDataGrantsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListDataGrantsResponse;

public class ListDataGrantsPublisher
implements SdkPublisher<ListDataGrantsResponse> {
    private final DataExchangeAsyncClient client;
    private final ListDataGrantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataGrantsPublisher(DataExchangeAsyncClient client, ListDataGrantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataGrantsPublisher(DataExchangeAsyncClient client, ListDataGrantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataGrantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataGrantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DataGrantSummaryEntry> dataGrantSummaries() {
        Function<ListDataGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataGrantSummaries() != null) {
                return response.dataGrantSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDataGrantsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDataGrantsResponseFetcher
    implements AsyncPageFetcher<ListDataGrantsResponse> {
        private ListDataGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataGrantsResponse> nextPage(ListDataGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListDataGrantsPublisher.this.client.listDataGrants(ListDataGrantsPublisher.this.firstRequest);
            }
            return ListDataGrantsPublisher.this.client.listDataGrants((ListDataGrantsRequest)((Object)ListDataGrantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

