/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.DataBrewResponse;
import software.amazon.awssdk.services.databrew.model.Sample;
import software.amazon.awssdk.services.databrew.model.SessionStatus;
import software.amazon.awssdk.services.databrew.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProjectResponse
extends DataBrewResponse
implements ToCopyableBuilder<Builder, DescribeProjectResponse> {
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(DescribeProjectResponse.getter(DescribeProjectResponse::createDate)).setter(DescribeProjectResponse.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(DescribeProjectResponse.getter(DescribeProjectResponse::createdBy)).setter(DescribeProjectResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatasetName").getter(DescribeProjectResponse.getter(DescribeProjectResponse::datasetName)).setter(DescribeProjectResponse.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedDate").getter(DescribeProjectResponse.getter(DescribeProjectResponse::lastModifiedDate)).setter(DescribeProjectResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedBy").getter(DescribeProjectResponse.getter(DescribeProjectResponse::lastModifiedBy)).setter(DescribeProjectResponse.setter(Builder::lastModifiedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeProjectResponse.getter(DescribeProjectResponse::name)).setter(DescribeProjectResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RECIPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecipeName").getter(DescribeProjectResponse.getter(DescribeProjectResponse::recipeName)).setter(DescribeProjectResponse.setter(Builder::recipeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeProjectResponse.getter(DescribeProjectResponse::resourceArn)).setter(DescribeProjectResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Sample> SAMPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sample").getter(DescribeProjectResponse.getter(DescribeProjectResponse::sample)).setter(DescribeProjectResponse.setter(Builder::sample)).constructor(Sample::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sample").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(DescribeProjectResponse.getter(DescribeProjectResponse::roleArn)).setter(DescribeProjectResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(DescribeProjectResponse.getter(DescribeProjectResponse::tags)).setter(DescribeProjectResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SESSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionStatus").getter(DescribeProjectResponse.getter(DescribeProjectResponse::sessionStatusAsString)).setter(DescribeProjectResponse.setter(Builder::sessionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionStatus").build()}).build();
    private static final SdkField<String> OPENED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OpenedBy").getter(DescribeProjectResponse.getter(DescribeProjectResponse::openedBy)).setter(DescribeProjectResponse.setter(Builder::openedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenedBy").build()}).build();
    private static final SdkField<Instant> OPEN_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("OpenDate").getter(DescribeProjectResponse.getter(DescribeProjectResponse::openDate)).setter(DescribeProjectResponse.setter(Builder::openDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DATE_FIELD, CREATED_BY_FIELD, DATASET_NAME_FIELD, LAST_MODIFIED_DATE_FIELD, LAST_MODIFIED_BY_FIELD, NAME_FIELD, RECIPE_NAME_FIELD, RESOURCE_ARN_FIELD, SAMPLE_FIELD, ROLE_ARN_FIELD, TAGS_FIELD, SESSION_STATUS_FIELD, OPENED_BY_FIELD, OPEN_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreateDate", CREATE_DATE_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("DatasetName", DATASET_NAME_FIELD);
            this.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
            this.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("RecipeName", RECIPE_NAME_FIELD);
            this.put("ResourceArn", RESOURCE_ARN_FIELD);
            this.put("Sample", SAMPLE_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("SessionStatus", SESSION_STATUS_FIELD);
            this.put("OpenedBy", OPENED_BY_FIELD);
            this.put("OpenDate", OPEN_DATE_FIELD);
        }
    });
    private final Instant createDate;
    private final String createdBy;
    private final String datasetName;
    private final Instant lastModifiedDate;
    private final String lastModifiedBy;
    private final String name;
    private final String recipeName;
    private final String resourceArn;
    private final Sample sample;
    private final String roleArn;
    private final Map<String, String> tags;
    private final String sessionStatus;
    private final String openedBy;
    private final Instant openDate;

    private DescribeProjectResponse(BuilderImpl builder) {
        super(builder);
        this.createDate = builder.createDate;
        this.createdBy = builder.createdBy;
        this.datasetName = builder.datasetName;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.name = builder.name;
        this.recipeName = builder.recipeName;
        this.resourceArn = builder.resourceArn;
        this.sample = builder.sample;
        this.roleArn = builder.roleArn;
        this.tags = builder.tags;
        this.sessionStatus = builder.sessionStatus;
        this.openedBy = builder.openedBy;
        this.openDate = builder.openDate;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final String name() {
        return this.name;
    }

    public final String recipeName() {
        return this.recipeName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Sample sample() {
        return this.sample;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final SessionStatus sessionStatus() {
        return SessionStatus.fromValue(this.sessionStatus);
    }

    public final String sessionStatusAsString() {
        return this.sessionStatus;
    }

    public final String openedBy() {
        return this.openedBy;
    }

    public final Instant openDate() {
        return this.openDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recipeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sample());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.openDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProjectResponse)) {
            return false;
        }
        DescribeProjectResponse other = (DescribeProjectResponse)((Object)obj);
        return Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.datasetName(), other.datasetName()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recipeName(), other.recipeName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.sample(), other.sample()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.sessionStatusAsString(), other.sessionStatusAsString()) && Objects.equals(this.openedBy(), other.openedBy()) && Objects.equals(this.openDate(), other.openDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProjectResponse").add("CreateDate", (Object)this.createDate()).add("CreatedBy", (Object)this.createdBy()).add("DatasetName", (Object)this.datasetName()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("Name", (Object)this.name()).add("RecipeName", (Object)this.recipeName()).add("ResourceArn", (Object)this.resourceArn()).add("Sample", (Object)this.sample()).add("RoleArn", (Object)this.roleArn()).add("Tags", this.hasTags() ? this.tags() : null).add("SessionStatus", (Object)this.sessionStatusAsString()).add("OpenedBy", (Object)this.openedBy()).add("OpenDate", (Object)this.openDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "DatasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RecipeName": {
                return Optional.ofNullable(clazz.cast(this.recipeName()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Sample": {
                return Optional.ofNullable(clazz.cast(this.sample()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SessionStatus": {
                return Optional.ofNullable(clazz.cast(this.sessionStatusAsString()));
            }
            case "OpenedBy": {
                return Optional.ofNullable(clazz.cast(this.openedBy()));
            }
            case "OpenDate": {
                return Optional.ofNullable(clazz.cast(this.openDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProjectResponse, T> g) {
        return obj -> g.apply((DescribeProjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataBrewResponse.BuilderImpl
    implements Builder {
        private Instant createDate;
        private String createdBy;
        private String datasetName;
        private Instant lastModifiedDate;
        private String lastModifiedBy;
        private String name;
        private String recipeName;
        private String resourceArn;
        private Sample sample;
        private String roleArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String sessionStatus;
        private String openedBy;
        private Instant openDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProjectResponse model) {
            super(model);
            this.createDate(model.createDate);
            this.createdBy(model.createdBy);
            this.datasetName(model.datasetName);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lastModifiedBy(model.lastModifiedBy);
            this.name(model.name);
            this.recipeName(model.recipeName);
            this.resourceArn(model.resourceArn);
            this.sample(model.sample);
            this.roleArn(model.roleArn);
            this.tags(model.tags);
            this.sessionStatus(model.sessionStatus);
            this.openedBy(model.openedBy);
            this.openDate(model.openDate);
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRecipeName() {
            return this.recipeName;
        }

        public final void setRecipeName(String recipeName) {
            this.recipeName = recipeName;
        }

        @Override
        public final Builder recipeName(String recipeName) {
            this.recipeName = recipeName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Sample.Builder getSample() {
            return this.sample != null ? this.sample.toBuilder() : null;
        }

        public final void setSample(Sample.BuilderImpl sample) {
            this.sample = sample != null ? sample.build() : null;
        }

        @Override
        public final Builder sample(Sample sample) {
            this.sample = sample;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getSessionStatus() {
            return this.sessionStatus;
        }

        public final void setSessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
        }

        @Override
        public final Builder sessionStatus(String sessionStatus) {
            this.sessionStatus = sessionStatus;
            return this;
        }

        @Override
        public final Builder sessionStatus(SessionStatus sessionStatus) {
            this.sessionStatus(sessionStatus == null ? null : sessionStatus.toString());
            return this;
        }

        public final String getOpenedBy() {
            return this.openedBy;
        }

        public final void setOpenedBy(String openedBy) {
            this.openedBy = openedBy;
        }

        @Override
        public final Builder openedBy(String openedBy) {
            this.openedBy = openedBy;
            return this;
        }

        public final Instant getOpenDate() {
            return this.openDate;
        }

        public final void setOpenDate(Instant openDate) {
            this.openDate = openDate;
        }

        @Override
        public final Builder openDate(Instant openDate) {
            this.openDate = openDate;
            return this;
        }

        @Override
        public DescribeProjectResponse build() {
            return new DescribeProjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataBrewResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProjectResponse> {
        public Builder createDate(Instant var1);

        public Builder createdBy(String var1);

        public Builder datasetName(String var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder lastModifiedBy(String var1);

        public Builder name(String var1);

        public Builder recipeName(String var1);

        public Builder resourceArn(String var1);

        public Builder sample(Sample var1);

        default public Builder sample(Consumer<Sample.Builder> sample) {
            return this.sample((Sample)((Sample.Builder)Sample.builder().applyMutation(sample)).build());
        }

        public Builder roleArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder sessionStatus(String var1);

        public Builder sessionStatus(SessionStatus var1);

        public Builder openedBy(String var1);

        public Builder openDate(Instant var1);
    }
}

