/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse;

public class DescribeReplicationConfigsPublisher
implements SdkPublisher<DescribeReplicationConfigsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeReplicationConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReplicationConfigsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReplicationConfigsPublisher(DatabaseMigrationAsyncClient client, DescribeReplicationConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReplicationConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReplicationConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeReplicationConfigsResponseFetcher
    implements AsyncPageFetcher<DescribeReplicationConfigsResponse> {
        private DescribeReplicationConfigsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReplicationConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeReplicationConfigsResponse> nextPage(DescribeReplicationConfigsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReplicationConfigsPublisher.this.client.describeReplicationConfigs(DescribeReplicationConfigsPublisher.this.firstRequest);
            }
            return DescribeReplicationConfigsPublisher.this.client.describeReplicationConfigs((DescribeReplicationConfigsRequest)((Object)DescribeReplicationConfigsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

