/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.databasemigration.DatabaseMigrationAsyncClient;
import software.amazon.awssdk.services.databasemigration.internal.UserAgentUtils;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse;

public class DescribeEngineVersionsPublisher
implements SdkPublisher<DescribeEngineVersionsResponse> {
    private final DatabaseMigrationAsyncClient client;
    private final DescribeEngineVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEngineVersionsPublisher(DatabaseMigrationAsyncClient client, DescribeEngineVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEngineVersionsPublisher(DatabaseMigrationAsyncClient client, DescribeEngineVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEngineVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEngineVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeEngineVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeEngineVersionsResponse> {
        private DescribeEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeEngineVersionsResponse> nextPage(DescribeEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEngineVersionsPublisher.this.client.describeEngineVersions(DescribeEngineVersionsPublisher.this.firstRequest);
            }
            return DescribeEngineVersionsPublisher.this.client.describeEngineVersions((DescribeEngineVersionsRequest)((Object)DescribeEngineVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

