/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.CollectorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollectorHealthCheck
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollectorHealthCheck> {
    private static final SdkField<String> COLLECTOR_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectorStatus").getter(CollectorHealthCheck.getter(CollectorHealthCheck::collectorStatusAsString)).setter(CollectorHealthCheck.setter(Builder::collectorStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectorStatus").build()}).build();
    private static final SdkField<Boolean> LOCAL_COLLECTOR_S3_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("LocalCollectorS3Access").getter(CollectorHealthCheck.getter(CollectorHealthCheck::localCollectorS3Access)).setter(CollectorHealthCheck.setter(Builder::localCollectorS3Access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalCollectorS3Access").build()}).build();
    private static final SdkField<Boolean> WEB_COLLECTOR_S3_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WebCollectorS3Access").getter(CollectorHealthCheck.getter(CollectorHealthCheck::webCollectorS3Access)).setter(CollectorHealthCheck.setter(Builder::webCollectorS3Access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCollectorS3Access").build()}).build();
    private static final SdkField<Boolean> WEB_COLLECTOR_GRANTED_ROLE_BASED_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("WebCollectorGrantedRoleBasedAccess").getter(CollectorHealthCheck.getter(CollectorHealthCheck::webCollectorGrantedRoleBasedAccess)).setter(CollectorHealthCheck.setter(Builder::webCollectorGrantedRoleBasedAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebCollectorGrantedRoleBasedAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTOR_STATUS_FIELD, LOCAL_COLLECTOR_S3_ACCESS_FIELD, WEB_COLLECTOR_S3_ACCESS_FIELD, WEB_COLLECTOR_GRANTED_ROLE_BASED_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CollectorStatus", COLLECTOR_STATUS_FIELD);
            this.put("LocalCollectorS3Access", LOCAL_COLLECTOR_S3_ACCESS_FIELD);
            this.put("WebCollectorS3Access", WEB_COLLECTOR_S3_ACCESS_FIELD);
            this.put("WebCollectorGrantedRoleBasedAccess", WEB_COLLECTOR_GRANTED_ROLE_BASED_ACCESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String collectorStatus;
    private final Boolean localCollectorS3Access;
    private final Boolean webCollectorS3Access;
    private final Boolean webCollectorGrantedRoleBasedAccess;

    private CollectorHealthCheck(BuilderImpl builder) {
        this.collectorStatus = builder.collectorStatus;
        this.localCollectorS3Access = builder.localCollectorS3Access;
        this.webCollectorS3Access = builder.webCollectorS3Access;
        this.webCollectorGrantedRoleBasedAccess = builder.webCollectorGrantedRoleBasedAccess;
    }

    public final CollectorStatus collectorStatus() {
        return CollectorStatus.fromValue(this.collectorStatus);
    }

    public final String collectorStatusAsString() {
        return this.collectorStatus;
    }

    public final Boolean localCollectorS3Access() {
        return this.localCollectorS3Access;
    }

    public final Boolean webCollectorS3Access() {
        return this.webCollectorS3Access;
    }

    public final Boolean webCollectorGrantedRoleBasedAccess() {
        return this.webCollectorGrantedRoleBasedAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.collectorStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.localCollectorS3Access());
        hashCode = 31 * hashCode + Objects.hashCode(this.webCollectorS3Access());
        hashCode = 31 * hashCode + Objects.hashCode(this.webCollectorGrantedRoleBasedAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectorHealthCheck)) {
            return false;
        }
        CollectorHealthCheck other = (CollectorHealthCheck)obj;
        return Objects.equals(this.collectorStatusAsString(), other.collectorStatusAsString()) && Objects.equals(this.localCollectorS3Access(), other.localCollectorS3Access()) && Objects.equals(this.webCollectorS3Access(), other.webCollectorS3Access()) && Objects.equals(this.webCollectorGrantedRoleBasedAccess(), other.webCollectorGrantedRoleBasedAccess());
    }

    public final String toString() {
        return ToString.builder((String)"CollectorHealthCheck").add("CollectorStatus", (Object)this.collectorStatusAsString()).add("LocalCollectorS3Access", (Object)this.localCollectorS3Access()).add("WebCollectorS3Access", (Object)this.webCollectorS3Access()).add("WebCollectorGrantedRoleBasedAccess", (Object)this.webCollectorGrantedRoleBasedAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectorStatus": {
                return Optional.ofNullable(clazz.cast(this.collectorStatusAsString()));
            }
            case "LocalCollectorS3Access": {
                return Optional.ofNullable(clazz.cast(this.localCollectorS3Access()));
            }
            case "WebCollectorS3Access": {
                return Optional.ofNullable(clazz.cast(this.webCollectorS3Access()));
            }
            case "WebCollectorGrantedRoleBasedAccess": {
                return Optional.ofNullable(clazz.cast(this.webCollectorGrantedRoleBasedAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CollectorHealthCheck, T> g) {
        return obj -> g.apply((CollectorHealthCheck)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String collectorStatus;
        private Boolean localCollectorS3Access;
        private Boolean webCollectorS3Access;
        private Boolean webCollectorGrantedRoleBasedAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(CollectorHealthCheck model) {
            this.collectorStatus(model.collectorStatus);
            this.localCollectorS3Access(model.localCollectorS3Access);
            this.webCollectorS3Access(model.webCollectorS3Access);
            this.webCollectorGrantedRoleBasedAccess(model.webCollectorGrantedRoleBasedAccess);
        }

        public final String getCollectorStatus() {
            return this.collectorStatus;
        }

        public final void setCollectorStatus(String collectorStatus) {
            this.collectorStatus = collectorStatus;
        }

        @Override
        public final Builder collectorStatus(String collectorStatus) {
            this.collectorStatus = collectorStatus;
            return this;
        }

        @Override
        public final Builder collectorStatus(CollectorStatus collectorStatus) {
            this.collectorStatus(collectorStatus == null ? null : collectorStatus.toString());
            return this;
        }

        public final Boolean getLocalCollectorS3Access() {
            return this.localCollectorS3Access;
        }

        public final void setLocalCollectorS3Access(Boolean localCollectorS3Access) {
            this.localCollectorS3Access = localCollectorS3Access;
        }

        @Override
        public final Builder localCollectorS3Access(Boolean localCollectorS3Access) {
            this.localCollectorS3Access = localCollectorS3Access;
            return this;
        }

        public final Boolean getWebCollectorS3Access() {
            return this.webCollectorS3Access;
        }

        public final void setWebCollectorS3Access(Boolean webCollectorS3Access) {
            this.webCollectorS3Access = webCollectorS3Access;
        }

        @Override
        public final Builder webCollectorS3Access(Boolean webCollectorS3Access) {
            this.webCollectorS3Access = webCollectorS3Access;
            return this;
        }

        public final Boolean getWebCollectorGrantedRoleBasedAccess() {
            return this.webCollectorGrantedRoleBasedAccess;
        }

        public final void setWebCollectorGrantedRoleBasedAccess(Boolean webCollectorGrantedRoleBasedAccess) {
            this.webCollectorGrantedRoleBasedAccess = webCollectorGrantedRoleBasedAccess;
        }

        @Override
        public final Builder webCollectorGrantedRoleBasedAccess(Boolean webCollectorGrantedRoleBasedAccess) {
            this.webCollectorGrantedRoleBasedAccess = webCollectorGrantedRoleBasedAccess;
            return this;
        }

        public CollectorHealthCheck build() {
            return new CollectorHealthCheck(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollectorHealthCheck> {
        public Builder collectorStatus(String var1);

        public Builder collectorStatus(CollectorStatus var1);

        public Builder localCollectorS3Access(Boolean var1);

        public Builder webCollectorS3Access(Boolean var1);

        public Builder webCollectorGrantedRoleBasedAccess(Boolean var1);
    }
}

