/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListSegmentDefinitionsResponse;
import software.amazon.awssdk.services.customerprofiles.model.SegmentDefinitionItem;

public class ListSegmentDefinitionsIterable
implements SdkIterable<ListSegmentDefinitionsResponse> {
    private final CustomerProfilesClient client;
    private final ListSegmentDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSegmentDefinitionsIterable(CustomerProfilesClient client, ListSegmentDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSegmentDefinitionsResponseFetcher();
    }

    public Iterator<ListSegmentDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SegmentDefinitionItem> items() {
        Function<ListSegmentDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSegmentDefinitionsResponseFetcher
    implements SyncPageFetcher<ListSegmentDefinitionsResponse> {
        private ListSegmentDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSegmentDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSegmentDefinitionsResponse nextPage(ListSegmentDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListSegmentDefinitionsIterable.this.client.listSegmentDefinitions(ListSegmentDefinitionsIterable.this.firstRequest);
            }
            return ListSegmentDefinitionsIterable.this.client.listSegmentDefinitions((ListSegmentDefinitionsRequest)((Object)ListSegmentDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

