/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3SourceProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3SourceProperties> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3SourceProperties.getter(S3SourceProperties::bucketName)).setter(S3SourceProperties.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> BUCKET_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketPrefix").getter(S3SourceProperties.getter(S3SourceProperties::bucketPrefix)).setter(S3SourceProperties.setter(Builder::bucketPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketPrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, BUCKET_PREFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BucketName", BUCKET_NAME_FIELD);
            this.put("BucketPrefix", BUCKET_PREFIX_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String bucketPrefix;

    private S3SourceProperties(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketPrefix = builder.bucketPrefix;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketPrefix() {
        return this.bucketPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketPrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SourceProperties)) {
            return false;
        }
        S3SourceProperties other = (S3SourceProperties)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketPrefix(), other.bucketPrefix());
    }

    public final String toString() {
        return ToString.builder((String)"S3SourceProperties").add("BucketName", (Object)this.bucketName()).add("BucketPrefix", (Object)this.bucketPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "BucketPrefix": {
                return Optional.ofNullable(clazz.cast(this.bucketPrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3SourceProperties, T> g) {
        return obj -> g.apply((S3SourceProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String bucketPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SourceProperties model) {
            this.bucketName(model.bucketName);
            this.bucketPrefix(model.bucketPrefix);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketPrefix() {
            return this.bucketPrefix;
        }

        public final void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
            return this;
        }

        public S3SourceProperties build() {
            return new S3SourceProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3SourceProperties> {
        public Builder bucketName(String var1);

        public Builder bucketPrefix(String var1);
    }
}

