/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.Profile;
import software.amazon.awssdk.services.customerprofiles.model.QueryResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileQueryResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileQueryResult> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(ProfileQueryResult.getter(ProfileQueryResult::profileId)).setter(ProfileQueryResult.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> QUERY_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryResult").getter(ProfileQueryResult.getter(ProfileQueryResult::queryResultAsString)).setter(ProfileQueryResult.setter(Builder::queryResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResult").build()}).build();
    private static final SdkField<Profile> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Profile").getter(ProfileQueryResult.getter(ProfileQueryResult::profile)).setter(ProfileQueryResult.setter(Builder::profile)).constructor(Profile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD, QUERY_RESULT_FIELD, PROFILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ProfileId", PROFILE_ID_FIELD);
            this.put("QueryResult", QUERY_RESULT_FIELD);
            this.put("Profile", PROFILE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String profileId;
    private final String queryResult;
    private final Profile profile;

    private ProfileQueryResult(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.queryResult = builder.queryResult;
        this.profile = builder.profile;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final QueryResult queryResult() {
        return QueryResult.fromValue(this.queryResult);
    }

    public final String queryResultAsString() {
        return this.queryResult;
    }

    public final Profile profile() {
        return this.profile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileQueryResult)) {
            return false;
        }
        ProfileQueryResult other = (ProfileQueryResult)obj;
        return Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.queryResultAsString(), other.queryResultAsString()) && Objects.equals(this.profile(), other.profile());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileQueryResult").add("ProfileId", (Object)this.profileId()).add("QueryResult", (Object)this.queryResultAsString()).add("Profile", (Object)this.profile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "QueryResult": {
                return Optional.ofNullable(clazz.cast(this.queryResultAsString()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ProfileQueryResult, T> g) {
        return obj -> g.apply((ProfileQueryResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String profileId;
        private String queryResult;
        private Profile profile;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileQueryResult model) {
            this.profileId(model.profileId);
            this.queryResult(model.queryResult);
            this.profile(model.profile);
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getQueryResult() {
            return this.queryResult;
        }

        public final void setQueryResult(String queryResult) {
            this.queryResult = queryResult;
        }

        @Override
        public final Builder queryResult(String queryResult) {
            this.queryResult = queryResult;
            return this;
        }

        @Override
        public final Builder queryResult(QueryResult queryResult) {
            this.queryResult(queryResult == null ? null : queryResult.toString());
            return this;
        }

        public final Profile.Builder getProfile() {
            return this.profile != null ? this.profile.toBuilder() : null;
        }

        public final void setProfile(Profile.BuilderImpl profile) {
            this.profile = profile != null ? profile.build() : null;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile = profile;
            return this;
        }

        public ProfileQueryResult build() {
            return new ProfileQueryResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileQueryResult> {
        public Builder profileId(String var1);

        public Builder queryResult(String var1);

        public Builder queryResult(QueryResult var1);

        public Builder profile(Profile var1);

        default public Builder profile(Consumer<Profile.Builder> profile) {
            return this.profile((Profile)((Profile.Builder)Profile.builder().applyMutation(profile)).build());
        }
    }
}

