/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.MatchIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRuleBasedMatchesResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, ListRuleBasedMatchesResponse> {
    private static final SdkField<List<String>> MATCH_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MatchIds").getter(ListRuleBasedMatchesResponse.getter(ListRuleBasedMatchesResponse::matchIds)).setter(ListRuleBasedMatchesResponse.setter(Builder::matchIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRuleBasedMatchesResponse.getter(ListRuleBasedMatchesResponse::nextToken)).setter(ListRuleBasedMatchesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_IDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("MatchIds", MATCH_IDS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<String> matchIds;
    private final String nextToken;

    private ListRuleBasedMatchesResponse(BuilderImpl builder) {
        super(builder);
        this.matchIds = builder.matchIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMatchIds() {
        return this.matchIds != null && !(this.matchIds instanceof SdkAutoConstructList);
    }

    public final List<String> matchIds() {
        return this.matchIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchIds() ? this.matchIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRuleBasedMatchesResponse)) {
            return false;
        }
        ListRuleBasedMatchesResponse other = (ListRuleBasedMatchesResponse)((Object)obj);
        return this.hasMatchIds() == other.hasMatchIds() && Objects.equals(this.matchIds(), other.matchIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRuleBasedMatchesResponse").add("MatchIds", this.hasMatchIds() ? this.matchIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchIds": {
                return Optional.ofNullable(clazz.cast(this.matchIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListRuleBasedMatchesResponse, T> g) {
        return obj -> g.apply((ListRuleBasedMatchesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private List<String> matchIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRuleBasedMatchesResponse model) {
            super(model);
            this.matchIds(model.matchIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getMatchIds() {
            if (this.matchIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchIds;
        }

        public final void setMatchIds(Collection<String> matchIds) {
            this.matchIds = MatchIdListCopier.copy(matchIds);
        }

        @Override
        public final Builder matchIds(Collection<String> matchIds) {
            this.matchIds = MatchIdListCopier.copy(matchIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchIds(String ... matchIds) {
            this.matchIds(Arrays.asList(matchIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRuleBasedMatchesResponse build() {
            return new ListRuleBasedMatchesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRuleBasedMatchesResponse> {
        public Builder matchIds(Collection<String> var1);

        public Builder matchIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

