/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.AttributeValueItem;
import software.amazon.awssdk.services.customerprofiles.model.AttributeValueItemListCopier;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileAttributeValuesResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, ListProfileAttributeValuesResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(ListProfileAttributeValuesResponse.getter(ListProfileAttributeValuesResponse::domainName)).setter(ListProfileAttributeValuesResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(ListProfileAttributeValuesResponse.getter(ListProfileAttributeValuesResponse::attributeName)).setter(ListProfileAttributeValuesResponse.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<AttributeValueItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Items").getter(ListProfileAttributeValuesResponse.getter(ListProfileAttributeValuesResponse::items)).setter(ListProfileAttributeValuesResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValueItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(ListProfileAttributeValuesResponse.getter(ListProfileAttributeValuesResponse::statusCode)).setter(ListProfileAttributeValuesResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ATTRIBUTE_NAME_FIELD, ITEMS_FIELD, STATUS_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("AttributeName", ATTRIBUTE_NAME_FIELD);
            this.put("Items", ITEMS_FIELD);
            this.put("StatusCode", STATUS_CODE_FIELD);
        }
    });
    private final String domainName;
    private final String attributeName;
    private final List<AttributeValueItem> items;
    private final Integer statusCode;

    private ListProfileAttributeValuesResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.attributeName = builder.attributeName;
        this.items = builder.items;
        this.statusCode = builder.statusCode;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AttributeValueItem> items() {
        return this.items;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileAttributeValuesResponse)) {
            return false;
        }
        ListProfileAttributeValuesResponse other = (ListProfileAttributeValuesResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.attributeName(), other.attributeName()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfileAttributeValuesResponse").add("DomainName", (Object)this.domainName()).add("AttributeName", (Object)this.attributeName()).add("Items", this.hasItems() ? this.items() : null).add("StatusCode", (Object)this.statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "Items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListProfileAttributeValuesResponse, T> g) {
        return obj -> g.apply((ListProfileAttributeValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String attributeName;
        private List<AttributeValueItem> items = DefaultSdkAutoConstructList.getInstance();
        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileAttributeValuesResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.attributeName(model.attributeName);
            this.items(model.items);
            this.statusCode(model.statusCode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final List<AttributeValueItem.Builder> getItems() {
            List<AttributeValueItem.Builder> result = AttributeValueItemListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AttributeValueItem.BuilderImpl> items) {
            this.items = AttributeValueItemListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AttributeValueItem> items) {
            this.items = AttributeValueItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AttributeValueItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AttributeValueItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AttributeValueItem)((AttributeValueItem.Builder)AttributeValueItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public ListProfileAttributeValuesResponse build() {
            return new ListProfileAttributeValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfileAttributeValuesResponse> {
        public Builder domainName(String var1);

        public Builder attributeName(String var1);

        public Builder items(Collection<AttributeValueItem> var1);

        public Builder items(AttributeValueItem ... var1);

        public Builder items(Consumer<AttributeValueItem.Builder> ... var1);

        public Builder statusCode(Integer var1);
    }
}

