/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.EstimateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSegmentEstimateResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetSegmentEstimateResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetSegmentEstimateResponse.getter(GetSegmentEstimateResponse::domainName)).setter(GetSegmentEstimateResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> ESTIMATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimateId").getter(GetSegmentEstimateResponse.getter(GetSegmentEstimateResponse::estimateId)).setter(GetSegmentEstimateResponse.setter(Builder::estimateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimateId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetSegmentEstimateResponse.getter(GetSegmentEstimateResponse::statusAsString)).setter(GetSegmentEstimateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ESTIMATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Estimate").getter(GetSegmentEstimateResponse.getter(GetSegmentEstimateResponse::estimate)).setter(GetSegmentEstimateResponse.setter(Builder::estimate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Estimate").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(GetSegmentEstimateResponse.getter(GetSegmentEstimateResponse::message)).setter(GetSegmentEstimateResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(GetSegmentEstimateResponse.getter(GetSegmentEstimateResponse::statusCode)).setter(GetSegmentEstimateResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ESTIMATE_ID_FIELD, STATUS_FIELD, ESTIMATE_FIELD, MESSAGE_FIELD, STATUS_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("EstimateId", ESTIMATE_ID_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Estimate", ESTIMATE_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("StatusCode", STATUS_CODE_FIELD);
        }
    });
    private final String domainName;
    private final String estimateId;
    private final String status;
    private final String estimate;
    private final String message;
    private final Integer statusCode;

    private GetSegmentEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.estimateId = builder.estimateId;
        this.status = builder.status;
        this.estimate = builder.estimate;
        this.message = builder.message;
        this.statusCode = builder.statusCode;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String estimateId() {
        return this.estimateId;
    }

    public final EstimateStatus status() {
        return EstimateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String estimate() {
        return this.estimate;
    }

    public final String message() {
        return this.message;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimate());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentEstimateResponse)) {
            return false;
        }
        GetSegmentEstimateResponse other = (GetSegmentEstimateResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.estimateId(), other.estimateId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.estimate(), other.estimate()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.statusCode(), other.statusCode());
    }

    public final String toString() {
        return ToString.builder((String)"GetSegmentEstimateResponse").add("DomainName", (Object)this.domainName()).add("EstimateId", (Object)this.estimateId()).add("Status", (Object)this.statusAsString()).add("Estimate", (Object)this.estimate()).add("Message", (Object)this.message()).add("StatusCode", (Object)this.statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "EstimateId": {
                return Optional.ofNullable(clazz.cast(this.estimateId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Estimate": {
                return Optional.ofNullable(clazz.cast(this.estimate()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentEstimateResponse, T> g) {
        return obj -> g.apply((GetSegmentEstimateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String estimateId;
        private String status;
        private String estimate;
        private String message;
        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentEstimateResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.estimateId(model.estimateId);
            this.status(model.status);
            this.estimate(model.estimate);
            this.message(model.message);
            this.statusCode(model.statusCode);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEstimateId() {
            return this.estimateId;
        }

        public final void setEstimateId(String estimateId) {
            this.estimateId = estimateId;
        }

        @Override
        public final Builder estimateId(String estimateId) {
            this.estimateId = estimateId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EstimateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEstimate() {
            return this.estimate;
        }

        public final void setEstimate(String estimate) {
            this.estimate = estimate;
        }

        @Override
        public final Builder estimate(String estimate) {
            this.estimate = estimate;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public GetSegmentEstimateResponse build() {
            return new GetSegmentEstimateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSegmentEstimateResponse> {
        public Builder domainName(String var1);

        public Builder estimateId(String var1);

        public Builder status(String var1);

        public Builder status(EstimateStatus var1);

        public Builder estimate(String var1);

        public Builder message(String var1);

        public Builder statusCode(Integer var1);
    }
}

