/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAttachmentUploadRequest
extends ConnectParticipantRequest
implements ToCopyableBuilder<Builder, StartAttachmentUploadRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(StartAttachmentUploadRequest.getter(StartAttachmentUploadRequest::contentType)).setter(StartAttachmentUploadRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()}).build();
    private static final SdkField<Long> ATTACHMENT_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AttachmentSizeInBytes").getter(StartAttachmentUploadRequest.getter(StartAttachmentUploadRequest::attachmentSizeInBytes)).setter(StartAttachmentUploadRequest.setter(Builder::attachmentSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentSizeInBytes").build()}).build();
    private static final SdkField<String> ATTACHMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentName").getter(StartAttachmentUploadRequest.getter(StartAttachmentUploadRequest::attachmentName)).setter(StartAttachmentUploadRequest.setter(Builder::attachmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartAttachmentUploadRequest.getter(StartAttachmentUploadRequest::clientToken)).setter(StartAttachmentUploadRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionToken").getter(StartAttachmentUploadRequest.getter(StartAttachmentUploadRequest::connectionToken)).setter(StartAttachmentUploadRequest.setter(Builder::connectionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, ATTACHMENT_SIZE_IN_BYTES_FIELD, ATTACHMENT_NAME_FIELD, CLIENT_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContentType", CONTENT_TYPE_FIELD);
            this.put("AttachmentSizeInBytes", ATTACHMENT_SIZE_IN_BYTES_FIELD);
            this.put("AttachmentName", ATTACHMENT_NAME_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("X-Amz-Bearer", CONNECTION_TOKEN_FIELD);
        }
    });
    private final String contentType;
    private final Long attachmentSizeInBytes;
    private final String attachmentName;
    private final String clientToken;
    private final String connectionToken;

    private StartAttachmentUploadRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.attachmentSizeInBytes = builder.attachmentSizeInBytes;
        this.attachmentName = builder.attachmentName;
        this.clientToken = builder.clientToken;
        this.connectionToken = builder.connectionToken;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final Long attachmentSizeInBytes() {
        return this.attachmentSizeInBytes;
    }

    public final String attachmentName() {
        return this.attachmentName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String connectionToken() {
        return this.connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAttachmentUploadRequest)) {
            return false;
        }
        StartAttachmentUploadRequest other = (StartAttachmentUploadRequest)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.attachmentSizeInBytes(), other.attachmentSizeInBytes()) && Objects.equals(this.attachmentName(), other.attachmentName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.connectionToken(), other.connectionToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartAttachmentUploadRequest").add("ContentType", (Object)this.contentType()).add("AttachmentSizeInBytes", (Object)this.attachmentSizeInBytes()).add("AttachmentName", (Object)this.attachmentName()).add("ClientToken", (Object)this.clientToken()).add("ConnectionToken", (Object)this.connectionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "AttachmentSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.attachmentSizeInBytes()));
            }
            case "AttachmentName": {
                return Optional.ofNullable(clazz.cast(this.attachmentName()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ConnectionToken": {
                return Optional.ofNullable(clazz.cast(this.connectionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartAttachmentUploadRequest, T> g) {
        return obj -> g.apply((StartAttachmentUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantRequest.BuilderImpl
    implements Builder {
        private String contentType;
        private Long attachmentSizeInBytes;
        private String attachmentName;
        private String clientToken;
        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAttachmentUploadRequest model) {
            super(model);
            this.contentType(model.contentType);
            this.attachmentSizeInBytes(model.attachmentSizeInBytes);
            this.attachmentName(model.attachmentName);
            this.clientToken(model.clientToken);
            this.connectionToken(model.connectionToken);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Long getAttachmentSizeInBytes() {
            return this.attachmentSizeInBytes;
        }

        public final void setAttachmentSizeInBytes(Long attachmentSizeInBytes) {
            this.attachmentSizeInBytes = attachmentSizeInBytes;
        }

        @Override
        public final Builder attachmentSizeInBytes(Long attachmentSizeInBytes) {
            this.attachmentSizeInBytes = attachmentSizeInBytes;
            return this;
        }

        public final String getAttachmentName() {
            return this.attachmentName;
        }

        public final void setAttachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
        }

        @Override
        public final Builder attachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConnectionToken() {
            return this.connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAttachmentUploadRequest build() {
            return new StartAttachmentUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectParticipantRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAttachmentUploadRequest> {
        public Builder contentType(String var1);

        public Builder attachmentSizeInBytes(Long var1);

        public Builder attachmentName(String var1);

        public Builder clientToken(String var1);

        public Builder connectionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

