/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ContactFlowModule;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesRequest;
import software.amazon.awssdk.services.connect.model.SearchContactFlowModulesResponse;

public class SearchContactFlowModulesPublisher
implements SdkPublisher<SearchContactFlowModulesResponse> {
    private final ConnectAsyncClient client;
    private final SearchContactFlowModulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchContactFlowModulesPublisher(ConnectAsyncClient client, SearchContactFlowModulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchContactFlowModulesPublisher(ConnectAsyncClient client, SearchContactFlowModulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchContactFlowModulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchContactFlowModulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactFlowModule> contactFlowModules() {
        Function<SearchContactFlowModulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactFlowModules() != null) {
                return response.contactFlowModules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchContactFlowModulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchContactFlowModulesResponseFetcher
    implements AsyncPageFetcher<SearchContactFlowModulesResponse> {
        private SearchContactFlowModulesResponseFetcher() {
        }

        public boolean hasNextPage(SearchContactFlowModulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchContactFlowModulesResponse> nextPage(SearchContactFlowModulesResponse previousPage) {
            if (previousPage == null) {
                return SearchContactFlowModulesPublisher.this.client.searchContactFlowModules(SearchContactFlowModulesPublisher.this.firstRequest);
            }
            return SearchContactFlowModulesPublisher.this.client.searchContactFlowModules((SearchContactFlowModulesRequest)((Object)SearchContactFlowModulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

