/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AgentHierarchyGroups;
import software.amazon.awssdk.services.connect.model.AgentResourceIdListCopier;
import software.amazon.awssdk.services.connect.model.Channel;
import software.amazon.awssdk.services.connect.model.ChannelListCopier;
import software.amazon.awssdk.services.connect.model.ContactAnalysis;
import software.amazon.awssdk.services.connect.model.ContactInitiationMethod;
import software.amazon.awssdk.services.connect.model.InitiationMethodListCopier;
import software.amazon.awssdk.services.connect.model.QueueIdListCopier;
import software.amazon.awssdk.services.connect.model.SearchableContactAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchCriteria> {
    private static final SdkField<List<String>> AGENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentIds").getter(SearchCriteria.getter(SearchCriteria::agentIds)).setter(SearchCriteria.setter(Builder::agentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AgentHierarchyGroups> AGENT_HIERARCHY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AgentHierarchyGroups").getter(SearchCriteria.getter(SearchCriteria::agentHierarchyGroups)).setter(SearchCriteria.setter(Builder::agentHierarchyGroups)).constructor(AgentHierarchyGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentHierarchyGroups").build()}).build();
    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Channels").getter(SearchCriteria.getter(SearchCriteria::channelsAsStrings)).setter(SearchCriteria.setter(Builder::channelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ContactAnalysis> CONTACT_ANALYSIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ContactAnalysis").getter(SearchCriteria.getter(SearchCriteria::contactAnalysis)).setter(SearchCriteria.setter(Builder::contactAnalysis)).constructor(ContactAnalysis::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactAnalysis").build()}).build();
    private static final SdkField<List<String>> INITIATION_METHODS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InitiationMethods").getter(SearchCriteria.getter(SearchCriteria::initiationMethodsAsStrings)).setter(SearchCriteria.setter(Builder::initiationMethodsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationMethods").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> QUEUE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueueIds").getter(SearchCriteria.getter(SearchCriteria::queueIds)).setter(SearchCriteria.setter(Builder::queueIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SearchableContactAttributes> SEARCHABLE_CONTACT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchableContactAttributes").getter(SearchCriteria.getter(SearchCriteria::searchableContactAttributes)).setter(SearchCriteria.setter(Builder::searchableContactAttributes)).constructor(SearchableContactAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchableContactAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_IDS_FIELD, AGENT_HIERARCHY_GROUPS_FIELD, CHANNELS_FIELD, CONTACT_ANALYSIS_FIELD, INITIATION_METHODS_FIELD, QUEUE_IDS_FIELD, SEARCHABLE_CONTACT_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AgentIds", AGENT_IDS_FIELD);
            this.put("AgentHierarchyGroups", AGENT_HIERARCHY_GROUPS_FIELD);
            this.put("Channels", CHANNELS_FIELD);
            this.put("ContactAnalysis", CONTACT_ANALYSIS_FIELD);
            this.put("InitiationMethods", INITIATION_METHODS_FIELD);
            this.put("QueueIds", QUEUE_IDS_FIELD);
            this.put("SearchableContactAttributes", SEARCHABLE_CONTACT_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> agentIds;
    private final AgentHierarchyGroups agentHierarchyGroups;
    private final List<String> channels;
    private final ContactAnalysis contactAnalysis;
    private final List<String> initiationMethods;
    private final List<String> queueIds;
    private final SearchableContactAttributes searchableContactAttributes;

    private SearchCriteria(BuilderImpl builder) {
        this.agentIds = builder.agentIds;
        this.agentHierarchyGroups = builder.agentHierarchyGroups;
        this.channels = builder.channels;
        this.contactAnalysis = builder.contactAnalysis;
        this.initiationMethods = builder.initiationMethods;
        this.queueIds = builder.queueIds;
        this.searchableContactAttributes = builder.searchableContactAttributes;
    }

    public final boolean hasAgentIds() {
        return this.agentIds != null && !(this.agentIds instanceof SdkAutoConstructList);
    }

    public final List<String> agentIds() {
        return this.agentIds;
    }

    public final AgentHierarchyGroups agentHierarchyGroups() {
        return this.agentHierarchyGroups;
    }

    public final List<Channel> channels() {
        return ChannelListCopier.copyStringToEnum(this.channels);
    }

    public final boolean hasChannels() {
        return this.channels != null && !(this.channels instanceof SdkAutoConstructList);
    }

    public final List<String> channelsAsStrings() {
        return this.channels;
    }

    public final ContactAnalysis contactAnalysis() {
        return this.contactAnalysis;
    }

    public final List<ContactInitiationMethod> initiationMethods() {
        return InitiationMethodListCopier.copyStringToEnum(this.initiationMethods);
    }

    public final boolean hasInitiationMethods() {
        return this.initiationMethods != null && !(this.initiationMethods instanceof SdkAutoConstructList);
    }

    public final List<String> initiationMethodsAsStrings() {
        return this.initiationMethods;
    }

    public final boolean hasQueueIds() {
        return this.queueIds != null && !(this.queueIds instanceof SdkAutoConstructList);
    }

    public final List<String> queueIds() {
        return this.queueIds;
    }

    public final SearchableContactAttributes searchableContactAttributes() {
        return this.searchableContactAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentIds() ? this.agentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.agentHierarchyGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannels() ? this.channelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactAnalysis());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitiationMethods() ? this.initiationMethodsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueueIds() ? this.queueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.searchableContactAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCriteria)) {
            return false;
        }
        SearchCriteria other = (SearchCriteria)obj;
        return this.hasAgentIds() == other.hasAgentIds() && Objects.equals(this.agentIds(), other.agentIds()) && Objects.equals(this.agentHierarchyGroups(), other.agentHierarchyGroups()) && this.hasChannels() == other.hasChannels() && Objects.equals(this.channelsAsStrings(), other.channelsAsStrings()) && Objects.equals(this.contactAnalysis(), other.contactAnalysis()) && this.hasInitiationMethods() == other.hasInitiationMethods() && Objects.equals(this.initiationMethodsAsStrings(), other.initiationMethodsAsStrings()) && this.hasQueueIds() == other.hasQueueIds() && Objects.equals(this.queueIds(), other.queueIds()) && Objects.equals(this.searchableContactAttributes(), other.searchableContactAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"SearchCriteria").add("AgentIds", this.hasAgentIds() ? this.agentIds() : null).add("AgentHierarchyGroups", (Object)this.agentHierarchyGroups()).add("Channels", this.hasChannels() ? this.channelsAsStrings() : null).add("ContactAnalysis", (Object)this.contactAnalysis()).add("InitiationMethods", this.hasInitiationMethods() ? this.initiationMethodsAsStrings() : null).add("QueueIds", this.hasQueueIds() ? this.queueIds() : null).add("SearchableContactAttributes", (Object)this.searchableContactAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentIds": {
                return Optional.ofNullable(clazz.cast(this.agentIds()));
            }
            case "AgentHierarchyGroups": {
                return Optional.ofNullable(clazz.cast(this.agentHierarchyGroups()));
            }
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channelsAsStrings()));
            }
            case "ContactAnalysis": {
                return Optional.ofNullable(clazz.cast(this.contactAnalysis()));
            }
            case "InitiationMethods": {
                return Optional.ofNullable(clazz.cast(this.initiationMethodsAsStrings()));
            }
            case "QueueIds": {
                return Optional.ofNullable(clazz.cast(this.queueIds()));
            }
            case "SearchableContactAttributes": {
                return Optional.ofNullable(clazz.cast(this.searchableContactAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchCriteria, T> g) {
        return obj -> g.apply((SearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> agentIds = DefaultSdkAutoConstructList.getInstance();
        private AgentHierarchyGroups agentHierarchyGroups;
        private List<String> channels = DefaultSdkAutoConstructList.getInstance();
        private ContactAnalysis contactAnalysis;
        private List<String> initiationMethods = DefaultSdkAutoConstructList.getInstance();
        private List<String> queueIds = DefaultSdkAutoConstructList.getInstance();
        private SearchableContactAttributes searchableContactAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCriteria model) {
            this.agentIds(model.agentIds);
            this.agentHierarchyGroups(model.agentHierarchyGroups);
            this.channelsWithStrings(model.channels);
            this.contactAnalysis(model.contactAnalysis);
            this.initiationMethodsWithStrings(model.initiationMethods);
            this.queueIds(model.queueIds);
            this.searchableContactAttributes(model.searchableContactAttributes);
        }

        public final Collection<String> getAgentIds() {
            if (this.agentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentIds;
        }

        public final void setAgentIds(Collection<String> agentIds) {
            this.agentIds = AgentResourceIdListCopier.copy(agentIds);
        }

        @Override
        public final Builder agentIds(Collection<String> agentIds) {
            this.agentIds = AgentResourceIdListCopier.copy(agentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentIds(String ... agentIds) {
            this.agentIds(Arrays.asList(agentIds));
            return this;
        }

        public final AgentHierarchyGroups.Builder getAgentHierarchyGroups() {
            return this.agentHierarchyGroups != null ? this.agentHierarchyGroups.toBuilder() : null;
        }

        public final void setAgentHierarchyGroups(AgentHierarchyGroups.BuilderImpl agentHierarchyGroups) {
            this.agentHierarchyGroups = agentHierarchyGroups != null ? agentHierarchyGroups.build() : null;
        }

        @Override
        public final Builder agentHierarchyGroups(AgentHierarchyGroups agentHierarchyGroups) {
            this.agentHierarchyGroups = agentHierarchyGroups;
            return this;
        }

        public final Collection<String> getChannels() {
            if (this.channels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelListCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelListCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String ... channels) {
            this.channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelListCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        public final ContactAnalysis.Builder getContactAnalysis() {
            return this.contactAnalysis != null ? this.contactAnalysis.toBuilder() : null;
        }

        public final void setContactAnalysis(ContactAnalysis.BuilderImpl contactAnalysis) {
            this.contactAnalysis = contactAnalysis != null ? contactAnalysis.build() : null;
        }

        @Override
        public final Builder contactAnalysis(ContactAnalysis contactAnalysis) {
            this.contactAnalysis = contactAnalysis;
            return this;
        }

        public final Collection<String> getInitiationMethods() {
            if (this.initiationMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return this.initiationMethods;
        }

        public final void setInitiationMethods(Collection<String> initiationMethods) {
            this.initiationMethods = InitiationMethodListCopier.copy(initiationMethods);
        }

        @Override
        public final Builder initiationMethodsWithStrings(Collection<String> initiationMethods) {
            this.initiationMethods = InitiationMethodListCopier.copy(initiationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiationMethodsWithStrings(String ... initiationMethods) {
            this.initiationMethodsWithStrings(Arrays.asList(initiationMethods));
            return this;
        }

        @Override
        public final Builder initiationMethods(Collection<ContactInitiationMethod> initiationMethods) {
            this.initiationMethods = InitiationMethodListCopier.copyEnumToString(initiationMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initiationMethods(ContactInitiationMethod ... initiationMethods) {
            this.initiationMethods(Arrays.asList(initiationMethods));
            return this;
        }

        public final Collection<String> getQueueIds() {
            if (this.queueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queueIds;
        }

        public final void setQueueIds(Collection<String> queueIds) {
            this.queueIds = QueueIdListCopier.copy(queueIds);
        }

        @Override
        public final Builder queueIds(Collection<String> queueIds) {
            this.queueIds = QueueIdListCopier.copy(queueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueIds(String ... queueIds) {
            this.queueIds(Arrays.asList(queueIds));
            return this;
        }

        public final SearchableContactAttributes.Builder getSearchableContactAttributes() {
            return this.searchableContactAttributes != null ? this.searchableContactAttributes.toBuilder() : null;
        }

        public final void setSearchableContactAttributes(SearchableContactAttributes.BuilderImpl searchableContactAttributes) {
            this.searchableContactAttributes = searchableContactAttributes != null ? searchableContactAttributes.build() : null;
        }

        @Override
        public final Builder searchableContactAttributes(SearchableContactAttributes searchableContactAttributes) {
            this.searchableContactAttributes = searchableContactAttributes;
            return this;
        }

        public SearchCriteria build() {
            return new SearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchCriteria> {
        public Builder agentIds(Collection<String> var1);

        public Builder agentIds(String ... var1);

        public Builder agentHierarchyGroups(AgentHierarchyGroups var1);

        default public Builder agentHierarchyGroups(Consumer<AgentHierarchyGroups.Builder> agentHierarchyGroups) {
            return this.agentHierarchyGroups((AgentHierarchyGroups)((AgentHierarchyGroups.Builder)AgentHierarchyGroups.builder().applyMutation(agentHierarchyGroups)).build());
        }

        public Builder channelsWithStrings(Collection<String> var1);

        public Builder channelsWithStrings(String ... var1);

        public Builder channels(Collection<Channel> var1);

        public Builder channels(Channel ... var1);

        public Builder contactAnalysis(ContactAnalysis var1);

        default public Builder contactAnalysis(Consumer<ContactAnalysis.Builder> contactAnalysis) {
            return this.contactAnalysis((ContactAnalysis)((ContactAnalysis.Builder)ContactAnalysis.builder().applyMutation(contactAnalysis)).build());
        }

        public Builder initiationMethodsWithStrings(Collection<String> var1);

        public Builder initiationMethodsWithStrings(String ... var1);

        public Builder initiationMethods(Collection<ContactInitiationMethod> var1);

        public Builder initiationMethods(ContactInitiationMethod ... var1);

        public Builder queueIds(Collection<String> var1);

        public Builder queueIds(String ... var1);

        public Builder searchableContactAttributes(SearchableContactAttributes var1);

        default public Builder searchableContactAttributes(Consumer<SearchableContactAttributes.Builder> searchableContactAttributes) {
            return this.searchableContactAttributes((SearchableContactAttributes)((SearchableContactAttributes.Builder)SearchableContactAttributes.builder().applyMutation(searchableContactAttributes)).build());
        }
    }
}

