/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.PropertyValidationExceptionReason;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyValidationExceptionProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyValidationExceptionProperty> {
    private static final SdkField<String> PROPERTY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PropertyPath").getter(PropertyValidationExceptionProperty.getter(PropertyValidationExceptionProperty::propertyPath)).setter(PropertyValidationExceptionProperty.setter(Builder::propertyPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyPath").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(PropertyValidationExceptionProperty.getter(PropertyValidationExceptionProperty::reasonAsString)).setter(PropertyValidationExceptionProperty.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(PropertyValidationExceptionProperty.getter(PropertyValidationExceptionProperty::message)).setter(PropertyValidationExceptionProperty.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_PATH_FIELD, REASON_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("PropertyPath", PROPERTY_PATH_FIELD);
            this.put("Reason", REASON_FIELD);
            this.put("Message", MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String propertyPath;
    private final String reason;
    private final String message;

    private PropertyValidationExceptionProperty(BuilderImpl builder) {
        this.propertyPath = builder.propertyPath;
        this.reason = builder.reason;
        this.message = builder.message;
    }

    public final String propertyPath() {
        return this.propertyPath;
    }

    public final PropertyValidationExceptionReason reason() {
        return PropertyValidationExceptionReason.fromValue(this.reason);
    }

    public final String reasonAsString() {
        return this.reason;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.reasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValidationExceptionProperty)) {
            return false;
        }
        PropertyValidationExceptionProperty other = (PropertyValidationExceptionProperty)obj;
        return Objects.equals(this.propertyPath(), other.propertyPath()) && Objects.equals(this.reasonAsString(), other.reasonAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyValidationExceptionProperty").add("PropertyPath", (Object)this.propertyPath()).add("Reason", (Object)this.reasonAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyPath": {
                return Optional.ofNullable(clazz.cast(this.propertyPath()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reasonAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PropertyValidationExceptionProperty, T> g) {
        return obj -> g.apply((PropertyValidationExceptionProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String propertyPath;
        private String reason;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValidationExceptionProperty model) {
            this.propertyPath(model.propertyPath);
            this.reason(model.reason);
            this.message(model.message);
        }

        public final String getPropertyPath() {
            return this.propertyPath;
        }

        public final void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        @Override
        public final Builder propertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(PropertyValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public PropertyValidationExceptionProperty build() {
            return new PropertyValidationExceptionProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyValidationExceptionProperty> {
        public Builder propertyPath(String var1);

        public Builder reason(String var1);

        public Builder reason(PropertyValidationExceptionReason var1);

        public Builder message(String var1);
    }
}

