/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.AgentStatusType;
import software.amazon.awssdk.services.connect.model.AgentStatusTypesCopier;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAgentStatusesRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListAgentStatusesRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListAgentStatusesRequest.getter(ListAgentStatusesRequest::instanceId)).setter(ListAgentStatusesRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAgentStatusesRequest.getter(ListAgentStatusesRequest::nextToken)).setter(ListAgentStatusesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListAgentStatusesRequest.getter(ListAgentStatusesRequest::maxResults)).setter(ListAgentStatusesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<List<String>> AGENT_STATUS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentStatusTypes").getter(ListAgentStatusesRequest.getter(ListAgentStatusesRequest::agentStatusTypesAsStrings)).setter(ListAgentStatusesRequest.setter(Builder::agentStatusTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AgentStatusTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, AGENT_STATUS_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceId", INSTANCE_ID_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("AgentStatusTypes", AGENT_STATUS_TYPES_FIELD);
        }
    });
    private final String instanceId;
    private final String nextToken;
    private final Integer maxResults;
    private final List<String> agentStatusTypes;

    private ListAgentStatusesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.agentStatusTypes = builder.agentStatusTypes;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final List<AgentStatusType> agentStatusTypes() {
        return AgentStatusTypesCopier.copyStringToEnum(this.agentStatusTypes);
    }

    public final boolean hasAgentStatusTypes() {
        return this.agentStatusTypes != null && !(this.agentStatusTypes instanceof SdkAutoConstructList);
    }

    public final List<String> agentStatusTypesAsStrings() {
        return this.agentStatusTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentStatusTypes() ? this.agentStatusTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentStatusesRequest)) {
            return false;
        }
        ListAgentStatusesRequest other = (ListAgentStatusesRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasAgentStatusTypes() == other.hasAgentStatusTypes() && Objects.equals(this.agentStatusTypesAsStrings(), other.agentStatusTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListAgentStatusesRequest").add("InstanceId", (Object)this.instanceId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("AgentStatusTypes", this.hasAgentStatusTypes() ? this.agentStatusTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "AgentStatusTypes": {
                return Optional.ofNullable(clazz.cast(this.agentStatusTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAgentStatusesRequest, T> g) {
        return obj -> g.apply((ListAgentStatusesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String nextToken;
        private Integer maxResults;
        private List<String> agentStatusTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentStatusesRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.agentStatusTypesWithStrings(model.agentStatusTypes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getAgentStatusTypes() {
            if (this.agentStatusTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentStatusTypes;
        }

        public final void setAgentStatusTypes(Collection<String> agentStatusTypes) {
            this.agentStatusTypes = AgentStatusTypesCopier.copy(agentStatusTypes);
        }

        @Override
        public final Builder agentStatusTypesWithStrings(Collection<String> agentStatusTypes) {
            this.agentStatusTypes = AgentStatusTypesCopier.copy(agentStatusTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatusTypesWithStrings(String ... agentStatusTypes) {
            this.agentStatusTypesWithStrings(Arrays.asList(agentStatusTypes));
            return this;
        }

        @Override
        public final Builder agentStatusTypes(Collection<AgentStatusType> agentStatusTypes) {
            this.agentStatusTypes = AgentStatusTypesCopier.copyEnumToString(agentStatusTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentStatusTypes(AgentStatusType ... agentStatusTypes) {
            this.agentStatusTypes(Arrays.asList(agentStatusTypes));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAgentStatusesRequest build() {
            return new ListAgentStatusesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAgentStatusesRequest> {
        public Builder instanceId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder agentStatusTypesWithStrings(Collection<String> var1);

        public Builder agentStatusTypesWithStrings(String ... var1);

        public Builder agentStatusTypes(Collection<AgentStatusType> var1);

        public Builder agentStatusTypes(AgentStatusType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

