/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehendmedical.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ICD10CMRelationshipType {
    OVERLAP("OVERLAP"),
    SYSTEM_ORGAN_SITE("SYSTEM_ORGAN_SITE"),
    QUALITY("QUALITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ICD10CMRelationshipType> VALUE_MAP;
    private final String value;

    private ICD10CMRelationshipType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ICD10CMRelationshipType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ICD10CMRelationshipType> knownValues() {
        EnumSet<ICD10CMRelationshipType> knownValues = EnumSet.allOf(ICD10CMRelationshipType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ICD10CMRelationshipType.class, ICD10CMRelationshipType::toString);
    }
}

