/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SentimentScore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SentimentScore> {
    private static final SdkField<Float> POSITIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Positive").getter(SentimentScore.getter(SentimentScore::positive)).setter(SentimentScore.setter(Builder::positive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Positive").build()}).build();
    private static final SdkField<Float> NEGATIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Negative").getter(SentimentScore.getter(SentimentScore::negative)).setter(SentimentScore.setter(Builder::negative)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negative").build()}).build();
    private static final SdkField<Float> NEUTRAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Neutral").getter(SentimentScore.getter(SentimentScore::neutral)).setter(SentimentScore.setter(Builder::neutral)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Neutral").build()}).build();
    private static final SdkField<Float> MIXED_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Mixed").getter(SentimentScore.getter(SentimentScore::mixed)).setter(SentimentScore.setter(Builder::mixed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mixed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSITIVE_FIELD, NEGATIVE_FIELD, NEUTRAL_FIELD, MIXED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Positive", POSITIVE_FIELD);
            this.put("Negative", NEGATIVE_FIELD);
            this.put("Neutral", NEUTRAL_FIELD);
            this.put("Mixed", MIXED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Float positive;
    private final Float negative;
    private final Float neutral;
    private final Float mixed;

    private SentimentScore(BuilderImpl builder) {
        this.positive = builder.positive;
        this.negative = builder.negative;
        this.neutral = builder.neutral;
        this.mixed = builder.mixed;
    }

    public final Float positive() {
        return this.positive;
    }

    public final Float negative() {
        return this.negative;
    }

    public final Float neutral() {
        return this.neutral;
    }

    public final Float mixed() {
        return this.mixed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.positive());
        hashCode = 31 * hashCode + Objects.hashCode(this.negative());
        hashCode = 31 * hashCode + Objects.hashCode(this.neutral());
        hashCode = 31 * hashCode + Objects.hashCode(this.mixed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SentimentScore)) {
            return false;
        }
        SentimentScore other = (SentimentScore)obj;
        return Objects.equals(this.positive(), other.positive()) && Objects.equals(this.negative(), other.negative()) && Objects.equals(this.neutral(), other.neutral()) && Objects.equals(this.mixed(), other.mixed());
    }

    public final String toString() {
        return ToString.builder((String)"SentimentScore").add("Positive", (Object)this.positive()).add("Negative", (Object)this.negative()).add("Neutral", (Object)this.neutral()).add("Mixed", (Object)this.mixed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Positive": {
                return Optional.ofNullable(clazz.cast(this.positive()));
            }
            case "Negative": {
                return Optional.ofNullable(clazz.cast(this.negative()));
            }
            case "Neutral": {
                return Optional.ofNullable(clazz.cast(this.neutral()));
            }
            case "Mixed": {
                return Optional.ofNullable(clazz.cast(this.mixed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SentimentScore, T> g) {
        return obj -> g.apply((SentimentScore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float positive;
        private Float negative;
        private Float neutral;
        private Float mixed;

        private BuilderImpl() {
        }

        private BuilderImpl(SentimentScore model) {
            this.positive(model.positive);
            this.negative(model.negative);
            this.neutral(model.neutral);
            this.mixed(model.mixed);
        }

        public final Float getPositive() {
            return this.positive;
        }

        public final void setPositive(Float positive) {
            this.positive = positive;
        }

        @Override
        public final Builder positive(Float positive) {
            this.positive = positive;
            return this;
        }

        public final Float getNegative() {
            return this.negative;
        }

        public final void setNegative(Float negative) {
            this.negative = negative;
        }

        @Override
        public final Builder negative(Float negative) {
            this.negative = negative;
            return this;
        }

        public final Float getNeutral() {
            return this.neutral;
        }

        public final void setNeutral(Float neutral) {
            this.neutral = neutral;
        }

        @Override
        public final Builder neutral(Float neutral) {
            this.neutral = neutral;
            return this;
        }

        public final Float getMixed() {
            return this.mixed;
        }

        public final void setMixed(Float mixed) {
            this.mixed = mixed;
        }

        @Override
        public final Builder mixed(Float mixed) {
            this.mixed = mixed;
            return this;
        }

        public SentimentScore build() {
            return new SentimentScore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SentimentScore> {
        public Builder positive(Float var1);

        public Builder negative(Float var1);

        public Builder neutral(Float var1);

        public Builder mixed(Float var1);
    }
}

