/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.CognitoIdentityProviderRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ProviderUserIdentifierType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdminLinkProviderForUserRequest
extends CognitoIdentityProviderRequest
implements ToCopyableBuilder<Builder, AdminLinkProviderForUserRequest> {
    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolId").getter(AdminLinkProviderForUserRequest.getter(AdminLinkProviderForUserRequest::userPoolId)).setter(AdminLinkProviderForUserRequest.setter(Builder::userPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()}).build();
    private static final SdkField<ProviderUserIdentifierType> DESTINATION_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationUser").getter(AdminLinkProviderForUserRequest.getter(AdminLinkProviderForUserRequest::destinationUser)).setter(AdminLinkProviderForUserRequest.setter(Builder::destinationUser)).constructor(ProviderUserIdentifierType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationUser").build()}).build();
    private static final SdkField<ProviderUserIdentifierType> SOURCE_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceUser").getter(AdminLinkProviderForUserRequest.getter(AdminLinkProviderForUserRequest::sourceUser)).setter(AdminLinkProviderForUserRequest.setter(Builder::sourceUser)).constructor(ProviderUserIdentifierType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUser").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_POOL_ID_FIELD, DESTINATION_USER_FIELD, SOURCE_USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UserPoolId", USER_POOL_ID_FIELD);
            this.put("DestinationUser", DESTINATION_USER_FIELD);
            this.put("SourceUser", SOURCE_USER_FIELD);
        }
    });
    private final String userPoolId;
    private final ProviderUserIdentifierType destinationUser;
    private final ProviderUserIdentifierType sourceUser;

    private AdminLinkProviderForUserRequest(BuilderImpl builder) {
        super(builder);
        this.userPoolId = builder.userPoolId;
        this.destinationUser = builder.destinationUser;
        this.sourceUser = builder.sourceUser;
    }

    public final String userPoolId() {
        return this.userPoolId;
    }

    public final ProviderUserIdentifierType destinationUser() {
        return this.destinationUser;
    }

    public final ProviderUserIdentifierType sourceUser() {
        return this.sourceUser;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceUser());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminLinkProviderForUserRequest)) {
            return false;
        }
        AdminLinkProviderForUserRequest other = (AdminLinkProviderForUserRequest)((Object)obj);
        return Objects.equals(this.userPoolId(), other.userPoolId()) && Objects.equals(this.destinationUser(), other.destinationUser()) && Objects.equals(this.sourceUser(), other.sourceUser());
    }

    public final String toString() {
        return ToString.builder((String)"AdminLinkProviderForUserRequest").add("UserPoolId", (Object)this.userPoolId()).add("DestinationUser", (Object)this.destinationUser()).add("SourceUser", (Object)this.sourceUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserPoolId": {
                return Optional.ofNullable(clazz.cast(this.userPoolId()));
            }
            case "DestinationUser": {
                return Optional.ofNullable(clazz.cast(this.destinationUser()));
            }
            case "SourceUser": {
                return Optional.ofNullable(clazz.cast(this.sourceUser()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AdminLinkProviderForUserRequest, T> g) {
        return obj -> g.apply((AdminLinkProviderForUserRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CognitoIdentityProviderRequest.BuilderImpl
    implements Builder {
        private String userPoolId;
        private ProviderUserIdentifierType destinationUser;
        private ProviderUserIdentifierType sourceUser;

        private BuilderImpl() {
        }

        private BuilderImpl(AdminLinkProviderForUserRequest model) {
            super(model);
            this.userPoolId(model.userPoolId);
            this.destinationUser(model.destinationUser);
            this.sourceUser(model.sourceUser);
        }

        public final String getUserPoolId() {
            return this.userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final ProviderUserIdentifierType.Builder getDestinationUser() {
            return this.destinationUser != null ? this.destinationUser.toBuilder() : null;
        }

        public final void setDestinationUser(ProviderUserIdentifierType.BuilderImpl destinationUser) {
            this.destinationUser = destinationUser != null ? destinationUser.build() : null;
        }

        @Override
        public final Builder destinationUser(ProviderUserIdentifierType destinationUser) {
            this.destinationUser = destinationUser;
            return this;
        }

        public final ProviderUserIdentifierType.Builder getSourceUser() {
            return this.sourceUser != null ? this.sourceUser.toBuilder() : null;
        }

        public final void setSourceUser(ProviderUserIdentifierType.BuilderImpl sourceUser) {
            this.sourceUser = sourceUser != null ? sourceUser.build() : null;
        }

        @Override
        public final Builder sourceUser(ProviderUserIdentifierType sourceUser) {
            this.sourceUser = sourceUser;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AdminLinkProviderForUserRequest build() {
            return new AdminLinkProviderForUserRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CognitoIdentityProviderRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AdminLinkProviderForUserRequest> {
        public Builder userPoolId(String var1);

        public Builder destinationUser(ProviderUserIdentifierType var1);

        default public Builder destinationUser(Consumer<ProviderUserIdentifierType.Builder> destinationUser) {
            return this.destinationUser((ProviderUserIdentifierType)((ProviderUserIdentifierType.Builder)ProviderUserIdentifierType.builder().applyMutation(destinationUser)).build());
        }

        public Builder sourceUser(ProviderUserIdentifierType var1);

        default public Builder sourceUser(Consumer<ProviderUserIdentifierType.Builder> sourceUser) {
            return this.sourceUser((ProviderUserIdentifierType)((ProviderUserIdentifierType.Builder)ProviderUserIdentifierType.builder().applyMutation(sourceUser)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

