/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codestarconnections.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codestarconnections.model.ProviderType;
import software.amazon.awssdk.services.codestarconnections.model.VpcConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Host
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Host> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Host.getter(Host::name)).setter(Host.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> HOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostArn").getter(Host.getter(Host::hostArn)).setter(Host.setter(Builder::hostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostArn").build()}).build();
    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderType").getter(Host.getter(Host::providerTypeAsString)).setter(Host.setter(Builder::providerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderType").build()}).build();
    private static final SdkField<String> PROVIDER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderEndpoint").getter(Host.getter(Host::providerEndpoint)).setter(Host.setter(Builder::providerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderEndpoint").build()}).build();
    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(Host.getter(Host::vpcConfiguration)).setter(Host.setter(Builder::vpcConfiguration)).constructor(VpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Host.getter(Host::status)).setter(Host.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(Host.getter(Host::statusMessage)).setter(Host.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, HOST_ARN_FIELD, PROVIDER_TYPE_FIELD, PROVIDER_ENDPOINT_FIELD, VPC_CONFIGURATION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("HostArn", HOST_ARN_FIELD);
            this.put("ProviderType", PROVIDER_TYPE_FIELD);
            this.put("ProviderEndpoint", PROVIDER_ENDPOINT_FIELD);
            this.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String hostArn;
    private final String providerType;
    private final String providerEndpoint;
    private final VpcConfiguration vpcConfiguration;
    private final String status;
    private final String statusMessage;

    private Host(BuilderImpl builder) {
        this.name = builder.name;
        this.hostArn = builder.hostArn;
        this.providerType = builder.providerType;
        this.providerEndpoint = builder.providerEndpoint;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final String name() {
        return this.name;
    }

    public final String hostArn() {
        return this.hostArn;
    }

    public final ProviderType providerType() {
        return ProviderType.fromValue(this.providerType);
    }

    public final String providerTypeAsString() {
        return this.providerType;
    }

    public final String providerEndpoint() {
        return this.providerEndpoint;
    }

    public final VpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final String status() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.hostArn(), other.hostArn()) && Objects.equals(this.providerTypeAsString(), other.providerTypeAsString()) && Objects.equals(this.providerEndpoint(), other.providerEndpoint()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"Host").add("Name", (Object)this.name()).add("HostArn", (Object)this.hostArn()).add("ProviderType", (Object)this.providerTypeAsString()).add("ProviderEndpoint", (Object)this.providerEndpoint()).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "HostArn": {
                return Optional.ofNullable(clazz.cast(this.hostArn()));
            }
            case "ProviderType": {
                return Optional.ofNullable(clazz.cast(this.providerTypeAsString()));
            }
            case "ProviderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.providerEndpoint()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Host, T> g) {
        return obj -> g.apply((Host)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String hostArn;
        private String providerType;
        private String providerEndpoint;
        private VpcConfiguration vpcConfiguration;
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Host model) {
            this.name(model.name);
            this.hostArn(model.hostArn);
            this.providerType(model.providerType);
            this.providerEndpoint(model.providerEndpoint);
            this.vpcConfiguration(model.vpcConfiguration);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getHostArn() {
            return this.hostArn;
        }

        public final void setHostArn(String hostArn) {
            this.hostArn = hostArn;
        }

        @Override
        public final Builder hostArn(String hostArn) {
            this.hostArn = hostArn;
            return this;
        }

        public final String getProviderType() {
            return this.providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        @Override
        public final Builder providerType(ProviderType providerType) {
            this.providerType(providerType == null ? null : providerType.toString());
            return this;
        }

        public final String getProviderEndpoint() {
            return this.providerEndpoint;
        }

        public final void setProviderEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
        }

        @Override
        public final Builder providerEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Host build() {
            return new Host(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Host> {
        public Builder name(String var1);

        public Builder hostArn(String var1);

        public Builder providerType(String var1);

        public Builder providerType(ProviderType var1);

        public Builder providerEndpoint(String var1);

        public Builder vpcConfiguration(VpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((VpcConfiguration)((VpcConfiguration.Builder)VpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder statusMessage(String var1);
    }
}

