/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codepipeline.model.Condition;
import software.amazon.awssdk.services.codepipeline.model.ConditionListCopier;
import software.amazon.awssdk.services.codepipeline.model.Result;
import software.amazon.awssdk.services.codepipeline.model.RetryConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailureConditions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailureConditions> {
    private static final SdkField<String> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("result").getter(FailureConditions.getter(FailureConditions::resultAsString)).setter(FailureConditions.setter(Builder::result)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<RetryConfiguration> RETRY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryConfiguration").getter(FailureConditions.getter(FailureConditions::retryConfiguration)).setter(FailureConditions.setter(Builder::retryConfiguration)).constructor(RetryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryConfiguration").build()}).build();
    private static final SdkField<List<Condition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditions").getter(FailureConditions.getter(FailureConditions::conditions)).setter(FailureConditions.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD, RETRY_CONFIGURATION_FIELD, CONDITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("result", RESULT_FIELD);
            this.put("retryConfiguration", RETRY_CONFIGURATION_FIELD);
            this.put("conditions", CONDITIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String result;
    private final RetryConfiguration retryConfiguration;
    private final List<Condition> conditions;

    private FailureConditions(BuilderImpl builder) {
        this.result = builder.result;
        this.retryConfiguration = builder.retryConfiguration;
        this.conditions = builder.conditions;
    }

    public final Result result() {
        return Result.fromValue(this.result);
    }

    public final String resultAsString() {
        return this.result;
    }

    public final RetryConfiguration retryConfiguration() {
        return this.retryConfiguration;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<Condition> conditions() {
        return this.conditions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureConditions)) {
            return false;
        }
        FailureConditions other = (FailureConditions)obj;
        return Objects.equals(this.resultAsString(), other.resultAsString()) && Objects.equals(this.retryConfiguration(), other.retryConfiguration()) && this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions());
    }

    public final String toString() {
        return ToString.builder((String)"FailureConditions").add("Result", (Object)this.resultAsString()).add("RetryConfiguration", (Object)this.retryConfiguration()).add("Conditions", this.hasConditions() ? this.conditions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "result": {
                return Optional.ofNullable(clazz.cast(this.resultAsString()));
            }
            case "retryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retryConfiguration()));
            }
            case "conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FailureConditions, T> g) {
        return obj -> g.apply((FailureConditions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String result;
        private RetryConfiguration retryConfiguration;
        private List<Condition> conditions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailureConditions model) {
            this.result(model.result);
            this.retryConfiguration(model.retryConfiguration);
            this.conditions(model.conditions);
        }

        public final String getResult() {
            return this.result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(Result result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final RetryConfiguration.Builder getRetryConfiguration() {
            return this.retryConfiguration != null ? this.retryConfiguration.toBuilder() : null;
        }

        public final void setRetryConfiguration(RetryConfiguration.BuilderImpl retryConfiguration) {
            this.retryConfiguration = retryConfiguration != null ? retryConfiguration.build() : null;
        }

        @Override
        public final Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public final List<Condition.Builder> getConditions() {
            List<Condition.Builder> result = ConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<Condition.BuilderImpl> conditions) {
            this.conditions = ConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<Condition> conditions) {
            this.conditions = ConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Condition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<Condition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (Condition)((Condition.Builder)Condition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public FailureConditions build() {
            return new FailureConditions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailureConditions> {
        public Builder result(String var1);

        public Builder result(Result var1);

        public Builder retryConfiguration(RetryConfiguration var1);

        default public Builder retryConfiguration(Consumer<RetryConfiguration.Builder> retryConfiguration) {
            return this.retryConfiguration((RetryConfiguration)((RetryConfiguration.Builder)RetryConfiguration.builder().applyMutation(retryConfiguration)).build());
        }

        public Builder conditions(Collection<Condition> var1);

        public Builder conditions(Condition ... var1);

        public Builder conditions(Consumer<Condition.Builder> ... var1);
    }
}

