/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.Target;
import software.amazon.awssdk.services.codecommit.model.TargetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePullRequestRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, CreatePullRequestRequest> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CreatePullRequestRequest.getter(CreatePullRequestRequest::title)).setter(CreatePullRequestRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreatePullRequestRequest.getter(CreatePullRequestRequest::description)).setter(CreatePullRequestRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(CreatePullRequestRequest.getter(CreatePullRequestRequest::targets)).setter(CreatePullRequestRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreatePullRequestRequest.getter(CreatePullRequestRequest::clientRequestToken)).setter(CreatePullRequestRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("title", TITLE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("targets", TARGETS_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        }
    });
    private final String title;
    private final String description;
    private final List<Target> targets;
    private final String clientRequestToken;

    private CreatePullRequestRequest(BuilderImpl builder) {
        super(builder);
        this.title = builder.title;
        this.description = builder.description;
        this.targets = builder.targets;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePullRequestRequest)) {
            return false;
        }
        CreatePullRequestRequest other = (CreatePullRequestRequest)((Object)obj);
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePullRequestRequest").add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("Targets", this.hasTargets() ? this.targets() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreatePullRequestRequest, T> g) {
        return obj -> g.apply((CreatePullRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String title;
        private String description;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePullRequestRequest model) {
            super(model);
            this.title(model.title);
            this.description(model.description);
            this.targets(model.targets);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetListCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetListCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePullRequestRequest build() {
            return new CreatePullRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePullRequestRequest> {
        public Builder title(String var1);

        public Builder description(String var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

