/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.StateValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetAlarmStateRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, SetAlarmStateRequest> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(SetAlarmStateRequest.getter(SetAlarmStateRequest::alarmName)).setter(SetAlarmStateRequest.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> STATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateValue").getter(SetAlarmStateRequest.getter(SetAlarmStateRequest::stateValueAsString)).setter(SetAlarmStateRequest.setter(Builder::stateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateValue").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(SetAlarmStateRequest.getter(SetAlarmStateRequest::stateReason)).setter(SetAlarmStateRequest.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final SdkField<String> STATE_REASON_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReasonData").getter(SetAlarmStateRequest.getter(SetAlarmStateRequest::stateReasonData)).setter(SetAlarmStateRequest.setter(Builder::stateReasonData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReasonData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, STATE_VALUE_FIELD, STATE_REASON_FIELD, STATE_REASON_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AlarmName", ALARM_NAME_FIELD);
            this.put("StateValue", STATE_VALUE_FIELD);
            this.put("StateReason", STATE_REASON_FIELD);
            this.put("StateReasonData", STATE_REASON_DATA_FIELD);
        }
    });
    private final String alarmName;
    private final String stateValue;
    private final String stateReason;
    private final String stateReasonData;

    private SetAlarmStateRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.stateValue = builder.stateValue;
        this.stateReason = builder.stateReason;
        this.stateReasonData = builder.stateReasonData;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final StateValue stateValue() {
        return StateValue.fromValue(this.stateValue);
    }

    public final String stateValueAsString() {
        return this.stateValue;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public final String stateReasonData() {
        return this.stateReasonData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReasonData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetAlarmStateRequest)) {
            return false;
        }
        SetAlarmStateRequest other = (SetAlarmStateRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.stateValueAsString(), other.stateValueAsString()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateReasonData(), other.stateReasonData());
    }

    public final String toString() {
        return ToString.builder((String)"SetAlarmStateRequest").add("AlarmName", (Object)this.alarmName()).add("StateValue", (Object)this.stateValueAsString()).add("StateReason", (Object)this.stateReason()).add("StateReasonData", (Object)this.stateReasonData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "StateValue": {
                return Optional.ofNullable(clazz.cast(this.stateValueAsString()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
            case "StateReasonData": {
                return Optional.ofNullable(clazz.cast(this.stateReasonData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SetAlarmStateRequest, T> g) {
        return obj -> g.apply((SetAlarmStateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private String stateValue;
        private String stateReason;
        private String stateReasonData;

        private BuilderImpl() {
        }

        private BuilderImpl(SetAlarmStateRequest model) {
            super(model);
            this.alarmName(model.alarmName);
            this.stateValue(model.stateValue);
            this.stateReason(model.stateReason);
            this.stateReasonData(model.stateReasonData);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        @Override
        public final Builder stateValue(StateValue stateValue) {
            this.stateValue(stateValue == null ? null : stateValue.toString());
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getStateReasonData() {
            return this.stateReasonData;
        }

        public final void setStateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
        }

        @Override
        public final Builder stateReasonData(String stateReasonData) {
            this.stateReasonData = stateReasonData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetAlarmStateRequest build() {
            return new SetAlarmStateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetAlarmStateRequest> {
        public Builder alarmName(String var1);

        public Builder stateValue(String var1);

        public Builder stateValue(StateValue var1);

        public Builder stateReason(String var1);

        public Builder stateReasonData(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

