/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricStat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricStat> {
    private static final SdkField<Metric> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metric").getter(MetricStat.getter(MetricStat::metric)).setter(MetricStat.setter(Builder::metric)).constructor(Metric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(MetricStat.getter(MetricStat::period)).setter(MetricStat.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> STAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stat").getter(MetricStat.getter(MetricStat::stat)).setter(MetricStat.setter(Builder::stat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stat").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(MetricStat.getter(MetricStat::unitAsString)).setter(MetricStat.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, PERIOD_FIELD, STAT_FIELD, UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Metric", METRIC_FIELD);
            this.put("Period", PERIOD_FIELD);
            this.put("Stat", STAT_FIELD);
            this.put("Unit", UNIT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Metric metric;
    private final Integer period;
    private final String stat;
    private final String unit;

    private MetricStat(BuilderImpl builder) {
        this.metric = builder.metric;
        this.period = builder.period;
        this.stat = builder.stat;
        this.unit = builder.unit;
    }

    public final Metric metric() {
        return this.metric;
    }

    public final Integer period() {
        return this.period;
    }

    public final String stat() {
        return this.stat;
    }

    public final StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metric());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.stat());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricStat)) {
            return false;
        }
        MetricStat other = (MetricStat)obj;
        return Objects.equals(this.metric(), other.metric()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.stat(), other.stat()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MetricStat").add("Metric", (Object)this.metric()).add("Period", (Object)this.period()).add("Stat", (Object)this.stat()).add("Unit", (Object)this.unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metric()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Stat": {
                return Optional.ofNullable(clazz.cast(this.stat()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<MetricStat, T> g) {
        return obj -> g.apply((MetricStat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Metric metric;
        private Integer period;
        private String stat;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricStat model) {
            this.metric(model.metric);
            this.period(model.period);
            this.stat(model.stat);
            this.unit(model.unit);
        }

        public final Metric.Builder getMetric() {
            return this.metric != null ? this.metric.toBuilder() : null;
        }

        public final void setMetric(Metric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric = metric;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getStat() {
            return this.stat;
        }

        public final void setStat(String stat) {
            this.stat = stat;
        }

        @Override
        public final Builder stat(String stat) {
            this.stat = stat;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public MetricStat build() {
            return new MetricStat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricStat> {
        public Builder metric(Metric var1);

        default public Builder metric(Consumer<Metric.Builder> metric) {
            return this.metric((Metric)((Metric.Builder)Metric.builder().applyMutation(metric)).build());
        }

        public Builder period(Integer var1);

        public Builder stat(String var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);
    }
}

