/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.Destination;
import software.amazon.awssdk.services.cloudtrail.model.DestinationsCopier;
import software.amazon.awssdk.services.cloudtrail.model.IngestionStatus;
import software.amazon.awssdk.services.cloudtrail.model.SourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetChannelResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, GetChannelResponse> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelArn").getter(GetChannelResponse.getter(GetChannelResponse::channelArn)).setter(GetChannelResponse.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetChannelResponse.getter(GetChannelResponse::name)).setter(GetChannelResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(GetChannelResponse.getter(GetChannelResponse::source)).setter(GetChannelResponse.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<SourceConfig> SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConfig").getter(GetChannelResponse.getter(GetChannelResponse::sourceConfig)).setter(GetChannelResponse.setter(Builder::sourceConfig)).constructor(SourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConfig").build()}).build();
    private static final SdkField<List<Destination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(GetChannelResponse.getter(GetChannelResponse::destinations)).setter(GetChannelResponse.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Destination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IngestionStatus> INGESTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IngestionStatus").getter(GetChannelResponse.getter(GetChannelResponse::ingestionStatus)).setter(GetChannelResponse.setter(Builder::ingestionStatus)).constructor(IngestionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, NAME_FIELD, SOURCE_FIELD, SOURCE_CONFIG_FIELD, DESTINATIONS_FIELD, INGESTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ChannelArn", CHANNEL_ARN_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Source", SOURCE_FIELD);
            this.put("SourceConfig", SOURCE_CONFIG_FIELD);
            this.put("Destinations", DESTINATIONS_FIELD);
            this.put("IngestionStatus", INGESTION_STATUS_FIELD);
        }
    });
    private final String channelArn;
    private final String name;
    private final String source;
    private final SourceConfig sourceConfig;
    private final List<Destination> destinations;
    private final IngestionStatus ingestionStatus;

    private GetChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.name = builder.name;
        this.source = builder.source;
        this.sourceConfig = builder.sourceConfig;
        this.destinations = builder.destinations;
        this.ingestionStatus = builder.ingestionStatus;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String name() {
        return this.name;
    }

    public final String source() {
        return this.source;
    }

    public final SourceConfig sourceConfig() {
        return this.sourceConfig;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<Destination> destinations() {
        return this.destinations;
    }

    public final IngestionStatus ingestionStatus() {
        return this.ingestionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetChannelResponse)) {
            return false;
        }
        GetChannelResponse other = (GetChannelResponse)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourceConfig(), other.sourceConfig()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.ingestionStatus(), other.ingestionStatus());
    }

    public final String toString() {
        return ToString.builder((String)"GetChannelResponse").add("ChannelArn", (Object)this.channelArn()).add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("SourceConfig", (Object)this.sourceConfig()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("IngestionStatus", (Object)this.ingestionStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "SourceConfig": {
                return Optional.ofNullable(clazz.cast(this.sourceConfig()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "IngestionStatus": {
                return Optional.ofNullable(clazz.cast(this.ingestionStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetChannelResponse, T> g) {
        return obj -> g.apply((GetChannelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String channelArn;
        private String name;
        private String source;
        private SourceConfig sourceConfig;
        private List<Destination> destinations = DefaultSdkAutoConstructList.getInstance();
        private IngestionStatus ingestionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetChannelResponse model) {
            super(model);
            this.channelArn(model.channelArn);
            this.name(model.name);
            this.source(model.source);
            this.sourceConfig(model.sourceConfig);
            this.destinations(model.destinations);
            this.ingestionStatus(model.ingestionStatus);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final SourceConfig.Builder getSourceConfig() {
            return this.sourceConfig != null ? this.sourceConfig.toBuilder() : null;
        }

        public final void setSourceConfig(SourceConfig.BuilderImpl sourceConfig) {
            this.sourceConfig = sourceConfig != null ? sourceConfig.build() : null;
        }

        @Override
        public final Builder sourceConfig(SourceConfig sourceConfig) {
            this.sourceConfig = sourceConfig;
            return this;
        }

        public final List<Destination.Builder> getDestinations() {
            List<Destination.Builder> result = DestinationsCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<Destination.BuilderImpl> destinations) {
            this.destinations = DestinationsCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationsCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Destination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (Destination)((Destination.Builder)Destination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IngestionStatus.Builder getIngestionStatus() {
            return this.ingestionStatus != null ? this.ingestionStatus.toBuilder() : null;
        }

        public final void setIngestionStatus(IngestionStatus.BuilderImpl ingestionStatus) {
            this.ingestionStatus = ingestionStatus != null ? ingestionStatus.build() : null;
        }

        @Override
        public final Builder ingestionStatus(IngestionStatus ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
            return this;
        }

        @Override
        public GetChannelResponse build() {
            return new GetChannelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetChannelResponse> {
        public Builder channelArn(String var1);

        public Builder name(String var1);

        public Builder source(String var1);

        public Builder sourceConfig(SourceConfig var1);

        default public Builder sourceConfig(Consumer<SourceConfig.Builder> sourceConfig) {
            return this.sourceConfig((SourceConfig)((SourceConfig.Builder)SourceConfig.builder().applyMutation(sourceConfig)).build());
        }

        public Builder destinations(Collection<Destination> var1);

        public Builder destinations(Destination ... var1);

        public Builder destinations(Consumer<Destination.Builder> ... var1);

        public Builder ingestionStatus(IngestionStatus var1);

        default public Builder ingestionStatus(Consumer<IngestionStatus.Builder> ingestionStatus) {
            return this.ingestionStatus((IngestionStatus)((IngestionStatus.Builder)IngestionStatus.builder().applyMutation(ingestionStatus)).build());
        }
    }
}

