/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.IdMappingTableSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListIdMappingTablesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListIdMappingTablesResponse;

public class ListIdMappingTablesPublisher
implements SdkPublisher<ListIdMappingTablesResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListIdMappingTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIdMappingTablesPublisher(CleanRoomsAsyncClient client, ListIdMappingTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIdMappingTablesPublisher(CleanRoomsAsyncClient client, ListIdMappingTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIdMappingTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIdMappingTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IdMappingTableSummary> idMappingTableSummaries() {
        Function<ListIdMappingTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.idMappingTableSummaries() != null) {
                return response.idMappingTableSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIdMappingTablesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIdMappingTablesResponseFetcher
    implements AsyncPageFetcher<ListIdMappingTablesResponse> {
        private ListIdMappingTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListIdMappingTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIdMappingTablesResponse> nextPage(ListIdMappingTablesResponse previousPage) {
            if (previousPage == null) {
                return ListIdMappingTablesPublisher.this.client.listIdMappingTables(ListIdMappingTablesPublisher.this.firstRequest);
            }
            return ListIdMappingTablesPublisher.this.client.listIdMappingTables((ListIdMappingTablesRequest)((Object)ListIdMappingTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

