/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateConfiguredAudienceModelAssociationRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateConfiguredAudienceModelAssociationRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CreateConfiguredAudienceModelAssociationRequest.getter(CreateConfiguredAudienceModelAssociationRequest::membershipIdentifier)).setter(CreateConfiguredAudienceModelAssociationRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelArn").getter(CreateConfiguredAudienceModelAssociationRequest.getter(CreateConfiguredAudienceModelAssociationRequest::configuredAudienceModelArn)).setter(CreateConfiguredAudienceModelAssociationRequest.setter(Builder::configuredAudienceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelArn").build()}).build();
    private static final SdkField<String> CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredAudienceModelAssociationName").getter(CreateConfiguredAudienceModelAssociationRequest.getter(CreateConfiguredAudienceModelAssociationRequest::configuredAudienceModelAssociationName)).setter(CreateConfiguredAudienceModelAssociationRequest.setter(Builder::configuredAudienceModelAssociationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelAssociationName").build()}).build();
    private static final SdkField<Boolean> MANAGE_RESOURCE_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("manageResourcePolicies").getter(CreateConfiguredAudienceModelAssociationRequest.getter(CreateConfiguredAudienceModelAssociationRequest::manageResourcePolicies)).setter(CreateConfiguredAudienceModelAssociationRequest.setter(Builder::manageResourcePolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageResourcePolicies").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateConfiguredAudienceModelAssociationRequest.getter(CreateConfiguredAudienceModelAssociationRequest::tags)).setter(CreateConfiguredAudienceModelAssociationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateConfiguredAudienceModelAssociationRequest.getter(CreateConfiguredAudienceModelAssociationRequest::description)).setter(CreateConfiguredAudienceModelAssociationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, CONFIGURED_AUDIENCE_MODEL_ARN_FIELD, CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_NAME_FIELD, MANAGE_RESOURCE_POLICIES_FIELD, TAGS_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
            this.put("configuredAudienceModelArn", CONFIGURED_AUDIENCE_MODEL_ARN_FIELD);
            this.put("configuredAudienceModelAssociationName", CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_NAME_FIELD);
            this.put("manageResourcePolicies", MANAGE_RESOURCE_POLICIES_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("description", DESCRIPTION_FIELD);
        }
    });
    private final String membershipIdentifier;
    private final String configuredAudienceModelArn;
    private final String configuredAudienceModelAssociationName;
    private final Boolean manageResourcePolicies;
    private final Map<String, String> tags;
    private final String description;

    private CreateConfiguredAudienceModelAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.configuredAudienceModelArn = builder.configuredAudienceModelArn;
        this.configuredAudienceModelAssociationName = builder.configuredAudienceModelAssociationName;
        this.manageResourcePolicies = builder.manageResourcePolicies;
        this.tags = builder.tags;
        this.description = builder.description;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String configuredAudienceModelArn() {
        return this.configuredAudienceModelArn;
    }

    public final String configuredAudienceModelAssociationName() {
        return this.configuredAudienceModelAssociationName;
    }

    public final Boolean manageResourcePolicies() {
        return this.manageResourcePolicies;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredAudienceModelAssociationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageResourcePolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredAudienceModelAssociationRequest)) {
            return false;
        }
        CreateConfiguredAudienceModelAssociationRequest other = (CreateConfiguredAudienceModelAssociationRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.configuredAudienceModelArn(), other.configuredAudienceModelArn()) && Objects.equals(this.configuredAudienceModelAssociationName(), other.configuredAudienceModelAssociationName()) && Objects.equals(this.manageResourcePolicies(), other.manageResourcePolicies()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"CreateConfiguredAudienceModelAssociationRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("ConfiguredAudienceModelArn", (Object)this.configuredAudienceModelArn()).add("ConfiguredAudienceModelAssociationName", (Object)this.configuredAudienceModelAssociationName()).add("ManageResourcePolicies", (Object)this.manageResourcePolicies()).add("Tags", this.hasTags() ? this.tags() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "configuredAudienceModelArn": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelArn()));
            }
            case "configuredAudienceModelAssociationName": {
                return Optional.ofNullable(clazz.cast(this.configuredAudienceModelAssociationName()));
            }
            case "manageResourcePolicies": {
                return Optional.ofNullable(clazz.cast(this.manageResourcePolicies()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredAudienceModelAssociationRequest, T> g) {
        return obj -> g.apply((CreateConfiguredAudienceModelAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String configuredAudienceModelArn;
        private String configuredAudienceModelAssociationName;
        private Boolean manageResourcePolicies;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredAudienceModelAssociationRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.configuredAudienceModelArn(model.configuredAudienceModelArn);
            this.configuredAudienceModelAssociationName(model.configuredAudienceModelAssociationName);
            this.manageResourcePolicies(model.manageResourcePolicies);
            this.tags(model.tags);
            this.description(model.description);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getConfiguredAudienceModelArn() {
            return this.configuredAudienceModelArn;
        }

        public final void setConfiguredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
        }

        @Override
        public final Builder configuredAudienceModelArn(String configuredAudienceModelArn) {
            this.configuredAudienceModelArn = configuredAudienceModelArn;
            return this;
        }

        public final String getConfiguredAudienceModelAssociationName() {
            return this.configuredAudienceModelAssociationName;
        }

        public final void setConfiguredAudienceModelAssociationName(String configuredAudienceModelAssociationName) {
            this.configuredAudienceModelAssociationName = configuredAudienceModelAssociationName;
        }

        @Override
        public final Builder configuredAudienceModelAssociationName(String configuredAudienceModelAssociationName) {
            this.configuredAudienceModelAssociationName = configuredAudienceModelAssociationName;
            return this;
        }

        public final Boolean getManageResourcePolicies() {
            return this.manageResourcePolicies;
        }

        public final void setManageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
        }

        @Override
        public final Builder manageResourcePolicies(Boolean manageResourcePolicies) {
            this.manageResourcePolicies = manageResourcePolicies;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConfiguredAudienceModelAssociationRequest build() {
            return new CreateConfiguredAudienceModelAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateConfiguredAudienceModelAssociationRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder configuredAudienceModelArn(String var1);

        public Builder configuredAudienceModelAssociationName(String var1);

        public Builder manageResourcePolicies(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder description(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

