/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmessaging.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkmessaging.ChimeSdkMessagingAsyncClient;
import software.amazon.awssdk.services.chimesdkmessaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsRequest;
import software.amazon.awssdk.services.chimesdkmessaging.model.ListChannelMembershipsResponse;

public class ListChannelMembershipsPublisher
implements SdkPublisher<ListChannelMembershipsResponse> {
    private final ChimeSdkMessagingAsyncClient client;
    private final ListChannelMembershipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelMembershipsPublisher(ChimeSdkMessagingAsyncClient client, ListChannelMembershipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelMembershipsPublisher(ChimeSdkMessagingAsyncClient client, ListChannelMembershipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelMembershipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelMembershipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChannelMembershipsResponseFetcher
    implements AsyncPageFetcher<ListChannelMembershipsResponse> {
        private ListChannelMembershipsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelMembershipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelMembershipsResponse> nextPage(ListChannelMembershipsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelMembershipsPublisher.this.client.listChannelMemberships(ListChannelMembershipsPublisher.this.firstRequest);
            }
            return ListChannelMembershipsPublisher.this.client.listChannelMemberships((ListChannelMembershipsRequest)((Object)ListChannelMembershipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

