/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkmediapipelines.model.RecordingFileFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3RecordingSinkConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3RecordingSinkConfiguration> {
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(S3RecordingSinkConfiguration.getter(S3RecordingSinkConfiguration::destination)).setter(S3RecordingSinkConfiguration.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> RECORDING_FILE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordingFileFormat").getter(S3RecordingSinkConfiguration.getter(S3RecordingSinkConfiguration::recordingFileFormatAsString)).setter(S3RecordingSinkConfiguration.setter(Builder::recordingFileFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordingFileFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, RECORDING_FILE_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Destination", DESTINATION_FIELD);
            this.put("RecordingFileFormat", RECORDING_FILE_FORMAT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String destination;
    private final String recordingFileFormat;

    private S3RecordingSinkConfiguration(BuilderImpl builder) {
        this.destination = builder.destination;
        this.recordingFileFormat = builder.recordingFileFormat;
    }

    public final String destination() {
        return this.destination;
    }

    public final RecordingFileFormat recordingFileFormat() {
        return RecordingFileFormat.fromValue(this.recordingFileFormat);
    }

    public final String recordingFileFormatAsString() {
        return this.recordingFileFormat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingFileFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3RecordingSinkConfiguration)) {
            return false;
        }
        S3RecordingSinkConfiguration other = (S3RecordingSinkConfiguration)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.recordingFileFormatAsString(), other.recordingFileFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"S3RecordingSinkConfiguration").add("Destination", (Object)(this.destination() == null ? null : "*** Sensitive Data Redacted ***")).add("RecordingFileFormat", (Object)this.recordingFileFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "RecordingFileFormat": {
                return Optional.ofNullable(clazz.cast(this.recordingFileFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3RecordingSinkConfiguration, T> g) {
        return obj -> g.apply((S3RecordingSinkConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destination;
        private String recordingFileFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(S3RecordingSinkConfiguration model) {
            this.destination(model.destination);
            this.recordingFileFormat(model.recordingFileFormat);
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getRecordingFileFormat() {
            return this.recordingFileFormat;
        }

        public final void setRecordingFileFormat(String recordingFileFormat) {
            this.recordingFileFormat = recordingFileFormat;
        }

        @Override
        public final Builder recordingFileFormat(String recordingFileFormat) {
            this.recordingFileFormat = recordingFileFormat;
            return this;
        }

        @Override
        public final Builder recordingFileFormat(RecordingFileFormat recordingFileFormat) {
            this.recordingFileFormat(recordingFileFormat == null ? null : recordingFileFormat.toString());
            return this;
        }

        public S3RecordingSinkConfiguration build() {
            return new S3RecordingSinkConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3RecordingSinkConfiguration> {
        public Builder destination(String var1);

        public Builder recordingFileFormat(String var1);

        public Builder recordingFileFormat(RecordingFileFormat var1);
    }
}

