/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.internal.UserAgentUtils;
import software.amazon.awssdk.services.chime.model.ListMeetingsRequest;
import software.amazon.awssdk.services.chime.model.ListMeetingsResponse;

public class ListMeetingsPublisher
implements SdkPublisher<ListMeetingsResponse> {
    private final ChimeAsyncClient client;
    private final ListMeetingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMeetingsPublisher(ChimeAsyncClient client, ListMeetingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMeetingsPublisher(ChimeAsyncClient client, ListMeetingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMeetingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMeetingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListMeetingsResponseFetcher
    implements AsyncPageFetcher<ListMeetingsResponse> {
        private ListMeetingsResponseFetcher() {
        }

        public boolean hasNextPage(ListMeetingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMeetingsResponse> nextPage(ListMeetingsResponse previousPage) {
            if (previousPage == null) {
                return ListMeetingsPublisher.this.client.listMeetings(ListMeetingsPublisher.this.firstRequest);
            }
            return ListMeetingsPublisher.this.client.listMeetings((ListMeetingsRequest)((Object)ListMeetingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

