/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.braket.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.braket.model.AlgorithmSpecification;
import software.amazon.awssdk.services.braket.model.Association;
import software.amazon.awssdk.services.braket.model.AssociationsCopier;
import software.amazon.awssdk.services.braket.model.BraketResponse;
import software.amazon.awssdk.services.braket.model.DeviceConfig;
import software.amazon.awssdk.services.braket.model.HybridJobQueueInfo;
import software.amazon.awssdk.services.braket.model.HyperParametersCopier;
import software.amazon.awssdk.services.braket.model.InputConfigListCopier;
import software.amazon.awssdk.services.braket.model.InputFileConfig;
import software.amazon.awssdk.services.braket.model.InstanceConfig;
import software.amazon.awssdk.services.braket.model.JobCheckpointConfig;
import software.amazon.awssdk.services.braket.model.JobEventDetails;
import software.amazon.awssdk.services.braket.model.JobEventsCopier;
import software.amazon.awssdk.services.braket.model.JobOutputDataConfig;
import software.amazon.awssdk.services.braket.model.JobPrimaryStatus;
import software.amazon.awssdk.services.braket.model.JobStoppingCondition;
import software.amazon.awssdk.services.braket.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetJobResponse
extends BraketResponse
implements ToCopyableBuilder<Builder, GetJobResponse> {
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("algorithmSpecification").getter(GetJobResponse.getter(GetJobResponse::algorithmSpecification)).setter(GetJobResponse.setter(Builder::algorithmSpecification)).constructor(AlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithmSpecification").build()}).build();
    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associations").getter(GetJobResponse.getter(GetJobResponse::associations)).setter(GetJobResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Association::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> BILLABLE_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("billableDuration").getter(GetJobResponse.getter(GetJobResponse::billableDuration)).setter(GetJobResponse.setter(Builder::billableDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billableDuration").build()}).build();
    private static final SdkField<JobCheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("checkpointConfig").getter(GetJobResponse.getter(GetJobResponse::checkpointConfig)).setter(GetJobResponse.setter(Builder::checkpointConfig)).constructor(JobCheckpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkpointConfig").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetJobResponse.getter(GetJobResponse::createdAt)).setter(GetJobResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<DeviceConfig> DEVICE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deviceConfig").getter(GetJobResponse.getter(GetJobResponse::deviceConfig)).setter(GetJobResponse.setter(Builder::deviceConfig)).constructor(DeviceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceConfig").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetJobResponse.getter(GetJobResponse::endedAt)).setter(GetJobResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<JobEventDetails>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("events").getter(GetJobResponse.getter(GetJobResponse::events)).setter(GetJobResponse.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobEventDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetJobResponse.getter(GetJobResponse::failureReason)).setter(GetJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("hyperParameters").getter(GetJobResponse.getter(GetJobResponse::hyperParameters)).setter(GetJobResponse.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<InputFileConfig>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputDataConfig").getter(GetJobResponse.getter(GetJobResponse::inputDataConfig)).setter(GetJobResponse.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputFileConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<InstanceConfig> INSTANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceConfig").getter(GetJobResponse.getter(GetJobResponse::instanceConfig)).setter(GetJobResponse.setter(Builder::instanceConfig)).constructor(InstanceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceConfig").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetJobResponse.getter(GetJobResponse::jobArn)).setter(GetJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetJobResponse.getter(GetJobResponse::jobName)).setter(GetJobResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<JobOutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputDataConfig").getter(GetJobResponse.getter(GetJobResponse::outputDataConfig)).setter(GetJobResponse.setter(Builder::outputDataConfig)).constructor(JobOutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()}).build();
    private static final SdkField<HybridJobQueueInfo> QUEUE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("queueInfo").getter(GetJobResponse.getter(GetJobResponse::queueInfo)).setter(GetJobResponse.setter(Builder::queueInfo)).constructor(HybridJobQueueInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueInfo").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetJobResponse.getter(GetJobResponse::roleArn)).setter(GetJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetJobResponse.getter(GetJobResponse::startedAt)).setter(GetJobResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetJobResponse.getter(GetJobResponse::statusAsString)).setter(GetJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<JobStoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stoppingCondition").getter(GetJobResponse.getter(GetJobResponse::stoppingCondition)).setter(GetJobResponse.setter(Builder::stoppingCondition)).constructor(JobStoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stoppingCondition").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetJobResponse.getter(GetJobResponse::tags)).setter(GetJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_SPECIFICATION_FIELD, ASSOCIATIONS_FIELD, BILLABLE_DURATION_FIELD, CHECKPOINT_CONFIG_FIELD, CREATED_AT_FIELD, DEVICE_CONFIG_FIELD, ENDED_AT_FIELD, EVENTS_FIELD, FAILURE_REASON_FIELD, HYPER_PARAMETERS_FIELD, INPUT_DATA_CONFIG_FIELD, INSTANCE_CONFIG_FIELD, JOB_ARN_FIELD, JOB_NAME_FIELD, OUTPUT_DATA_CONFIG_FIELD, QUEUE_INFO_FIELD, ROLE_ARN_FIELD, STARTED_AT_FIELD, STATUS_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("algorithmSpecification", ALGORITHM_SPECIFICATION_FIELD);
            this.put("associations", ASSOCIATIONS_FIELD);
            this.put("billableDuration", BILLABLE_DURATION_FIELD);
            this.put("checkpointConfig", CHECKPOINT_CONFIG_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("deviceConfig", DEVICE_CONFIG_FIELD);
            this.put("endedAt", ENDED_AT_FIELD);
            this.put("events", EVENTS_FIELD);
            this.put("failureReason", FAILURE_REASON_FIELD);
            this.put("hyperParameters", HYPER_PARAMETERS_FIELD);
            this.put("inputDataConfig", INPUT_DATA_CONFIG_FIELD);
            this.put("instanceConfig", INSTANCE_CONFIG_FIELD);
            this.put("jobArn", JOB_ARN_FIELD);
            this.put("jobName", JOB_NAME_FIELD);
            this.put("outputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
            this.put("queueInfo", QUEUE_INFO_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("stoppingCondition", STOPPING_CONDITION_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final AlgorithmSpecification algorithmSpecification;
    private final List<Association> associations;
    private final Integer billableDuration;
    private final JobCheckpointConfig checkpointConfig;
    private final Instant createdAt;
    private final DeviceConfig deviceConfig;
    private final Instant endedAt;
    private final List<JobEventDetails> events;
    private final String failureReason;
    private final Map<String, String> hyperParameters;
    private final List<InputFileConfig> inputDataConfig;
    private final InstanceConfig instanceConfig;
    private final String jobArn;
    private final String jobName;
    private final JobOutputDataConfig outputDataConfig;
    private final HybridJobQueueInfo queueInfo;
    private final String roleArn;
    private final Instant startedAt;
    private final String status;
    private final JobStoppingCondition stoppingCondition;
    private final Map<String, String> tags;

    private GetJobResponse(BuilderImpl builder) {
        super(builder);
        this.algorithmSpecification = builder.algorithmSpecification;
        this.associations = builder.associations;
        this.billableDuration = builder.billableDuration;
        this.checkpointConfig = builder.checkpointConfig;
        this.createdAt = builder.createdAt;
        this.deviceConfig = builder.deviceConfig;
        this.endedAt = builder.endedAt;
        this.events = builder.events;
        this.failureReason = builder.failureReason;
        this.hyperParameters = builder.hyperParameters;
        this.inputDataConfig = builder.inputDataConfig;
        this.instanceConfig = builder.instanceConfig;
        this.jobArn = builder.jobArn;
        this.jobName = builder.jobName;
        this.outputDataConfig = builder.outputDataConfig;
        this.queueInfo = builder.queueInfo;
        this.roleArn = builder.roleArn;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    public final AlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<Association> associations() {
        return this.associations;
    }

    public final Integer billableDuration() {
        return this.billableDuration;
    }

    public final JobCheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeviceConfig deviceConfig() {
        return this.deviceConfig;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<JobEventDetails> events() {
        return this.events;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final boolean hasHyperParameters() {
        return this.hyperParameters != null && !(this.hyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public final boolean hasInputDataConfig() {
        return this.inputDataConfig != null && !(this.inputDataConfig instanceof SdkAutoConstructList);
    }

    public final List<InputFileConfig> inputDataConfig() {
        return this.inputDataConfig;
    }

    public final InstanceConfig instanceConfig() {
        return this.instanceConfig;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobOutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final HybridJobQueueInfo queueInfo() {
        return this.queueInfo;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final JobPrimaryStatus status() {
        return JobPrimaryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final JobStoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.billableDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHyperParameters() ? this.hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDataConfig() ? this.inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetJobResponse)) {
            return false;
        }
        GetJobResponse other = (GetJobResponse)((Object)obj);
        return Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations()) && Objects.equals(this.billableDuration(), other.billableDuration()) && Objects.equals(this.checkpointConfig(), other.checkpointConfig()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deviceConfig(), other.deviceConfig()) && Objects.equals(this.endedAt(), other.endedAt()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.failureReason(), other.failureReason()) && this.hasHyperParameters() == other.hasHyperParameters() && Objects.equals(this.hyperParameters(), other.hyperParameters()) && this.hasInputDataConfig() == other.hasInputDataConfig() && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.instanceConfig(), other.instanceConfig()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.queueInfo(), other.queueInfo()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetJobResponse").add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("Associations", this.hasAssociations() ? this.associations() : null).add("BillableDuration", (Object)this.billableDuration()).add("CheckpointConfig", (Object)this.checkpointConfig()).add("CreatedAt", (Object)this.createdAt()).add("DeviceConfig", (Object)this.deviceConfig()).add("EndedAt", (Object)this.endedAt()).add("Events", this.hasEvents() ? this.events() : null).add("FailureReason", (Object)this.failureReason()).add("HyperParameters", this.hasHyperParameters() ? this.hyperParameters() : null).add("InputDataConfig", this.hasInputDataConfig() ? this.inputDataConfig() : null).add("InstanceConfig", (Object)this.instanceConfig()).add("JobArn", (Object)this.jobArn()).add("JobName", (Object)this.jobName()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("QueueInfo", (Object)this.queueInfo()).add("RoleArn", (Object)this.roleArn()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "algorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
            case "billableDuration": {
                return Optional.ofNullable(clazz.cast(this.billableDuration()));
            }
            case "checkpointConfig": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfig()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deviceConfig": {
                return Optional.ofNullable(clazz.cast(this.deviceConfig()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "hyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "inputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "instanceConfig": {
                return Optional.ofNullable(clazz.cast(this.instanceConfig()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "outputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "queueInfo": {
                return Optional.ofNullable(clazz.cast(this.queueInfo()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "stoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetJobResponse, T> g) {
        return obj -> g.apply((GetJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BraketResponse.BuilderImpl
    implements Builder {
        private AlgorithmSpecification algorithmSpecification;
        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();
        private Integer billableDuration;
        private JobCheckpointConfig checkpointConfig;
        private Instant createdAt;
        private DeviceConfig deviceConfig;
        private Instant endedAt;
        private List<JobEventDetails> events = DefaultSdkAutoConstructList.getInstance();
        private String failureReason;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private List<InputFileConfig> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private InstanceConfig instanceConfig;
        private String jobArn;
        private String jobName;
        private JobOutputDataConfig outputDataConfig;
        private HybridJobQueueInfo queueInfo;
        private String roleArn;
        private Instant startedAt;
        private String status;
        private JobStoppingCondition stoppingCondition;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetJobResponse model) {
            super(model);
            this.algorithmSpecification(model.algorithmSpecification);
            this.associations(model.associations);
            this.billableDuration(model.billableDuration);
            this.checkpointConfig(model.checkpointConfig);
            this.createdAt(model.createdAt);
            this.deviceConfig(model.deviceConfig);
            this.endedAt(model.endedAt);
            this.events(model.events);
            this.failureReason(model.failureReason);
            this.hyperParameters(model.hyperParameters);
            this.inputDataConfig(model.inputDataConfig);
            this.instanceConfig(model.instanceConfig);
            this.jobArn(model.jobArn);
            this.jobName(model.jobName);
            this.outputDataConfig(model.outputDataConfig);
            this.queueInfo(model.queueInfo);
            this.roleArn(model.roleArn);
            this.startedAt(model.startedAt);
            this.status(model.status);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = AssociationsCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = AssociationsCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = AssociationsCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (Association)((Association.Builder)Association.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getBillableDuration() {
            return this.billableDuration;
        }

        public final void setBillableDuration(Integer billableDuration) {
            this.billableDuration = billableDuration;
        }

        @Override
        public final Builder billableDuration(Integer billableDuration) {
            this.billableDuration = billableDuration;
            return this;
        }

        public final JobCheckpointConfig.Builder getCheckpointConfig() {
            return this.checkpointConfig != null ? this.checkpointConfig.toBuilder() : null;
        }

        public final void setCheckpointConfig(JobCheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        @Override
        public final Builder checkpointConfig(JobCheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DeviceConfig.Builder getDeviceConfig() {
            return this.deviceConfig != null ? this.deviceConfig.toBuilder() : null;
        }

        public final void setDeviceConfig(DeviceConfig.BuilderImpl deviceConfig) {
            this.deviceConfig = deviceConfig != null ? deviceConfig.build() : null;
        }

        @Override
        public final Builder deviceConfig(DeviceConfig deviceConfig) {
            this.deviceConfig = deviceConfig;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final List<JobEventDetails.Builder> getEvents() {
            List<JobEventDetails.Builder> result = JobEventsCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<JobEventDetails.BuilderImpl> events) {
            this.events = JobEventsCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<JobEventDetails> events) {
            this.events = JobEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(JobEventDetails ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<JobEventDetails.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (JobEventDetails)((JobEventDetails.Builder)JobEventDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (this.hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final List<InputFileConfig.Builder> getInputDataConfig() {
            List<InputFileConfig.Builder> result = InputConfigListCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<InputFileConfig.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputConfigListCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<InputFileConfig> inputDataConfig) {
            this.inputDataConfig = InputConfigListCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(InputFileConfig ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<InputFileConfig.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (InputFileConfig)((InputFileConfig.Builder)InputFileConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final InstanceConfig.Builder getInstanceConfig() {
            return this.instanceConfig != null ? this.instanceConfig.toBuilder() : null;
        }

        public final void setInstanceConfig(InstanceConfig.BuilderImpl instanceConfig) {
            this.instanceConfig = instanceConfig != null ? instanceConfig.build() : null;
        }

        @Override
        public final Builder instanceConfig(InstanceConfig instanceConfig) {
            this.instanceConfig = instanceConfig;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final JobOutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(JobOutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(JobOutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final HybridJobQueueInfo.Builder getQueueInfo() {
            return this.queueInfo != null ? this.queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(HybridJobQueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(HybridJobQueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobPrimaryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final JobStoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(JobStoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(JobStoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetJobResponse build() {
            return new GetJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BraketResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetJobResponse> {
        public Builder algorithmSpecification(AlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((AlgorithmSpecification)((AlgorithmSpecification.Builder)AlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder associations(Collection<Association> var1);

        public Builder associations(Association ... var1);

        public Builder associations(Consumer<Association.Builder> ... var1);

        public Builder billableDuration(Integer var1);

        public Builder checkpointConfig(JobCheckpointConfig var1);

        default public Builder checkpointConfig(Consumer<JobCheckpointConfig.Builder> checkpointConfig) {
            return this.checkpointConfig((JobCheckpointConfig)((JobCheckpointConfig.Builder)JobCheckpointConfig.builder().applyMutation(checkpointConfig)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder deviceConfig(DeviceConfig var1);

        default public Builder deviceConfig(Consumer<DeviceConfig.Builder> deviceConfig) {
            return this.deviceConfig((DeviceConfig)((DeviceConfig.Builder)DeviceConfig.builder().applyMutation(deviceConfig)).build());
        }

        public Builder endedAt(Instant var1);

        public Builder events(Collection<JobEventDetails> var1);

        public Builder events(JobEventDetails ... var1);

        public Builder events(Consumer<JobEventDetails.Builder> ... var1);

        public Builder failureReason(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder inputDataConfig(Collection<InputFileConfig> var1);

        public Builder inputDataConfig(InputFileConfig ... var1);

        public Builder inputDataConfig(Consumer<InputFileConfig.Builder> ... var1);

        public Builder instanceConfig(InstanceConfig var1);

        default public Builder instanceConfig(Consumer<InstanceConfig.Builder> instanceConfig) {
            return this.instanceConfig((InstanceConfig)((InstanceConfig.Builder)InstanceConfig.builder().applyMutation(instanceConfig)).build());
        }

        public Builder jobArn(String var1);

        public Builder jobName(String var1);

        public Builder outputDataConfig(JobOutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<JobOutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((JobOutputDataConfig)((JobOutputDataConfig.Builder)JobOutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder queueInfo(HybridJobQueueInfo var1);

        default public Builder queueInfo(Consumer<HybridJobQueueInfo.Builder> queueInfo) {
            return this.queueInfo((HybridJobQueueInfo)((HybridJobQueueInfo.Builder)HybridJobQueueInfo.builder().applyMutation(queueInfo)).build());
        }

        public Builder roleArn(String var1);

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(JobPrimaryStatus var1);

        public Builder stoppingCondition(JobStoppingCondition var1);

        default public Builder stoppingCondition(Consumer<JobStoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((JobStoppingCondition)((JobStoppingCondition.Builder)JobStoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

