/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContentPolicyAssessment;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailContextualGroundingPolicyAssessment;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailInvocationMetrics;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailSensitiveInformationPolicyAssessment;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailTopicPolicyAssessment;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailWordPolicyAssessment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailAssessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailAssessment> {
    private static final SdkField<GuardrailTopicPolicyAssessment> TOPIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::topicPolicy)).setter(GuardrailAssessment.setter(Builder::topicPolicy)).constructor(GuardrailTopicPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicy").build()}).build();
    private static final SdkField<GuardrailContentPolicyAssessment> CONTENT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::contentPolicy)).setter(GuardrailAssessment.setter(Builder::contentPolicy)).constructor(GuardrailContentPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicy").build()}).build();
    private static final SdkField<GuardrailWordPolicyAssessment> WORD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wordPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::wordPolicy)).setter(GuardrailAssessment.setter(Builder::wordPolicy)).constructor(GuardrailWordPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicy").build()}).build();
    private static final SdkField<GuardrailSensitiveInformationPolicyAssessment> SENSITIVE_INFORMATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensitiveInformationPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::sensitiveInformationPolicy)).setter(GuardrailAssessment.setter(Builder::sensitiveInformationPolicy)).constructor(GuardrailSensitiveInformationPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicy").build()}).build();
    private static final SdkField<GuardrailContextualGroundingPolicyAssessment> CONTEXTUAL_GROUNDING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contextualGroundingPolicy").getter(GuardrailAssessment.getter(GuardrailAssessment::contextualGroundingPolicy)).setter(GuardrailAssessment.setter(Builder::contextualGroundingPolicy)).constructor(GuardrailContextualGroundingPolicyAssessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicy").build()}).build();
    private static final SdkField<GuardrailInvocationMetrics> INVOCATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("invocationMetrics").getter(GuardrailAssessment.getter(GuardrailAssessment::invocationMetrics)).setter(GuardrailAssessment.setter(Builder::invocationMetrics)).constructor(GuardrailInvocationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_POLICY_FIELD, CONTENT_POLICY_FIELD, WORD_POLICY_FIELD, SENSITIVE_INFORMATION_POLICY_FIELD, CONTEXTUAL_GROUNDING_POLICY_FIELD, INVOCATION_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("topicPolicy", TOPIC_POLICY_FIELD);
            this.put("contentPolicy", CONTENT_POLICY_FIELD);
            this.put("wordPolicy", WORD_POLICY_FIELD);
            this.put("sensitiveInformationPolicy", SENSITIVE_INFORMATION_POLICY_FIELD);
            this.put("contextualGroundingPolicy", CONTEXTUAL_GROUNDING_POLICY_FIELD);
            this.put("invocationMetrics", INVOCATION_METRICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final GuardrailTopicPolicyAssessment topicPolicy;
    private final GuardrailContentPolicyAssessment contentPolicy;
    private final GuardrailWordPolicyAssessment wordPolicy;
    private final GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy;
    private final GuardrailContextualGroundingPolicyAssessment contextualGroundingPolicy;
    private final GuardrailInvocationMetrics invocationMetrics;

    private GuardrailAssessment(BuilderImpl builder) {
        this.topicPolicy = builder.topicPolicy;
        this.contentPolicy = builder.contentPolicy;
        this.wordPolicy = builder.wordPolicy;
        this.sensitiveInformationPolicy = builder.sensitiveInformationPolicy;
        this.contextualGroundingPolicy = builder.contextualGroundingPolicy;
        this.invocationMetrics = builder.invocationMetrics;
    }

    public final GuardrailTopicPolicyAssessment topicPolicy() {
        return this.topicPolicy;
    }

    public final GuardrailContentPolicyAssessment contentPolicy() {
        return this.contentPolicy;
    }

    public final GuardrailWordPolicyAssessment wordPolicy() {
        return this.wordPolicy;
    }

    public final GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy() {
        return this.sensitiveInformationPolicy;
    }

    public final GuardrailContextualGroundingPolicyAssessment contextualGroundingPolicy() {
        return this.contextualGroundingPolicy;
    }

    public final GuardrailInvocationMetrics invocationMetrics() {
        return this.invocationMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitiveInformationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextualGroundingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationMetrics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAssessment)) {
            return false;
        }
        GuardrailAssessment other = (GuardrailAssessment)obj;
        return Objects.equals(this.topicPolicy(), other.topicPolicy()) && Objects.equals(this.contentPolicy(), other.contentPolicy()) && Objects.equals(this.wordPolicy(), other.wordPolicy()) && Objects.equals(this.sensitiveInformationPolicy(), other.sensitiveInformationPolicy()) && Objects.equals(this.contextualGroundingPolicy(), other.contextualGroundingPolicy()) && Objects.equals(this.invocationMetrics(), other.invocationMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailAssessment").add("TopicPolicy", (Object)this.topicPolicy()).add("ContentPolicy", (Object)this.contentPolicy()).add("WordPolicy", (Object)this.wordPolicy()).add("SensitiveInformationPolicy", (Object)this.sensitiveInformationPolicy()).add("ContextualGroundingPolicy", (Object)this.contextualGroundingPolicy()).add("InvocationMetrics", (Object)this.invocationMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topicPolicy": {
                return Optional.ofNullable(clazz.cast(this.topicPolicy()));
            }
            case "contentPolicy": {
                return Optional.ofNullable(clazz.cast(this.contentPolicy()));
            }
            case "wordPolicy": {
                return Optional.ofNullable(clazz.cast(this.wordPolicy()));
            }
            case "sensitiveInformationPolicy": {
                return Optional.ofNullable(clazz.cast(this.sensitiveInformationPolicy()));
            }
            case "contextualGroundingPolicy": {
                return Optional.ofNullable(clazz.cast(this.contextualGroundingPolicy()));
            }
            case "invocationMetrics": {
                return Optional.ofNullable(clazz.cast(this.invocationMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAssessment, T> g) {
        return obj -> g.apply((GuardrailAssessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private GuardrailTopicPolicyAssessment topicPolicy;
        private GuardrailContentPolicyAssessment contentPolicy;
        private GuardrailWordPolicyAssessment wordPolicy;
        private GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy;
        private GuardrailContextualGroundingPolicyAssessment contextualGroundingPolicy;
        private GuardrailInvocationMetrics invocationMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAssessment model) {
            this.topicPolicy(model.topicPolicy);
            this.contentPolicy(model.contentPolicy);
            this.wordPolicy(model.wordPolicy);
            this.sensitiveInformationPolicy(model.sensitiveInformationPolicy);
            this.contextualGroundingPolicy(model.contextualGroundingPolicy);
            this.invocationMetrics(model.invocationMetrics);
        }

        public final GuardrailTopicPolicyAssessment.Builder getTopicPolicy() {
            return this.topicPolicy != null ? this.topicPolicy.toBuilder() : null;
        }

        public final void setTopicPolicy(GuardrailTopicPolicyAssessment.BuilderImpl topicPolicy) {
            this.topicPolicy = topicPolicy != null ? topicPolicy.build() : null;
        }

        @Override
        public final Builder topicPolicy(GuardrailTopicPolicyAssessment topicPolicy) {
            this.topicPolicy = topicPolicy;
            return this;
        }

        public final GuardrailContentPolicyAssessment.Builder getContentPolicy() {
            return this.contentPolicy != null ? this.contentPolicy.toBuilder() : null;
        }

        public final void setContentPolicy(GuardrailContentPolicyAssessment.BuilderImpl contentPolicy) {
            this.contentPolicy = contentPolicy != null ? contentPolicy.build() : null;
        }

        @Override
        public final Builder contentPolicy(GuardrailContentPolicyAssessment contentPolicy) {
            this.contentPolicy = contentPolicy;
            return this;
        }

        public final GuardrailWordPolicyAssessment.Builder getWordPolicy() {
            return this.wordPolicy != null ? this.wordPolicy.toBuilder() : null;
        }

        public final void setWordPolicy(GuardrailWordPolicyAssessment.BuilderImpl wordPolicy) {
            this.wordPolicy = wordPolicy != null ? wordPolicy.build() : null;
        }

        @Override
        public final Builder wordPolicy(GuardrailWordPolicyAssessment wordPolicy) {
            this.wordPolicy = wordPolicy;
            return this;
        }

        public final GuardrailSensitiveInformationPolicyAssessment.Builder getSensitiveInformationPolicy() {
            return this.sensitiveInformationPolicy != null ? this.sensitiveInformationPolicy.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment.BuilderImpl sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy != null ? sensitiveInformationPolicy.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy;
            return this;
        }

        public final GuardrailContextualGroundingPolicyAssessment.Builder getContextualGroundingPolicy() {
            return this.contextualGroundingPolicy != null ? this.contextualGroundingPolicy.toBuilder() : null;
        }

        public final void setContextualGroundingPolicy(GuardrailContextualGroundingPolicyAssessment.BuilderImpl contextualGroundingPolicy) {
            this.contextualGroundingPolicy = contextualGroundingPolicy != null ? contextualGroundingPolicy.build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicy(GuardrailContextualGroundingPolicyAssessment contextualGroundingPolicy) {
            this.contextualGroundingPolicy = contextualGroundingPolicy;
            return this;
        }

        public final GuardrailInvocationMetrics.Builder getInvocationMetrics() {
            return this.invocationMetrics != null ? this.invocationMetrics.toBuilder() : null;
        }

        public final void setInvocationMetrics(GuardrailInvocationMetrics.BuilderImpl invocationMetrics) {
            this.invocationMetrics = invocationMetrics != null ? invocationMetrics.build() : null;
        }

        @Override
        public final Builder invocationMetrics(GuardrailInvocationMetrics invocationMetrics) {
            this.invocationMetrics = invocationMetrics;
            return this;
        }

        public GuardrailAssessment build() {
            return new GuardrailAssessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailAssessment> {
        public Builder topicPolicy(GuardrailTopicPolicyAssessment var1);

        default public Builder topicPolicy(Consumer<GuardrailTopicPolicyAssessment.Builder> topicPolicy) {
            return this.topicPolicy((GuardrailTopicPolicyAssessment)((GuardrailTopicPolicyAssessment.Builder)GuardrailTopicPolicyAssessment.builder().applyMutation(topicPolicy)).build());
        }

        public Builder contentPolicy(GuardrailContentPolicyAssessment var1);

        default public Builder contentPolicy(Consumer<GuardrailContentPolicyAssessment.Builder> contentPolicy) {
            return this.contentPolicy((GuardrailContentPolicyAssessment)((GuardrailContentPolicyAssessment.Builder)GuardrailContentPolicyAssessment.builder().applyMutation(contentPolicy)).build());
        }

        public Builder wordPolicy(GuardrailWordPolicyAssessment var1);

        default public Builder wordPolicy(Consumer<GuardrailWordPolicyAssessment.Builder> wordPolicy) {
            return this.wordPolicy((GuardrailWordPolicyAssessment)((GuardrailWordPolicyAssessment.Builder)GuardrailWordPolicyAssessment.builder().applyMutation(wordPolicy)).build());
        }

        public Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicyAssessment var1);

        default public Builder sensitiveInformationPolicy(Consumer<GuardrailSensitiveInformationPolicyAssessment.Builder> sensitiveInformationPolicy) {
            return this.sensitiveInformationPolicy((GuardrailSensitiveInformationPolicyAssessment)((GuardrailSensitiveInformationPolicyAssessment.Builder)GuardrailSensitiveInformationPolicyAssessment.builder().applyMutation(sensitiveInformationPolicy)).build());
        }

        public Builder contextualGroundingPolicy(GuardrailContextualGroundingPolicyAssessment var1);

        default public Builder contextualGroundingPolicy(Consumer<GuardrailContextualGroundingPolicyAssessment.Builder> contextualGroundingPolicy) {
            return this.contextualGroundingPolicy((GuardrailContextualGroundingPolicyAssessment)((GuardrailContextualGroundingPolicyAssessment.Builder)GuardrailContextualGroundingPolicyAssessment.builder().applyMutation(contextualGroundingPolicy)).build());
        }

        public Builder invocationMetrics(GuardrailInvocationMetrics var1);

        default public Builder invocationMetrics(Consumer<GuardrailInvocationMetrics.Builder> invocationMetrics) {
            return this.invocationMetrics((GuardrailInvocationMetrics)((GuardrailInvocationMetrics.Builder)GuardrailInvocationMetrics.builder().applyMutation(invocationMetrics)).build());
        }
    }
}

