/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestHypervisorConfigurationRequest
extends BackupGatewayRequest
implements ToCopyableBuilder<Builder, TestHypervisorConfigurationRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(TestHypervisorConfigurationRequest.getter(TestHypervisorConfigurationRequest::gatewayArn)).setter(TestHypervisorConfigurationRequest.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()}).build();
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Host").getter(TestHypervisorConfigurationRequest.getter(TestHypervisorConfigurationRequest::host)).setter(TestHypervisorConfigurationRequest.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Password").getter(TestHypervisorConfigurationRequest.getter(TestHypervisorConfigurationRequest::password)).setter(TestHypervisorConfigurationRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(TestHypervisorConfigurationRequest.getter(TestHypervisorConfigurationRequest::username)).setter(TestHypervisorConfigurationRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, HOST_FIELD, PASSWORD_FIELD, USERNAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("GatewayArn", GATEWAY_ARN_FIELD);
            this.put("Host", HOST_FIELD);
            this.put("Password", PASSWORD_FIELD);
            this.put("Username", USERNAME_FIELD);
        }
    });
    private final String gatewayArn;
    private final String host;
    private final String password;
    private final String username;

    private TestHypervisorConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayArn = builder.gatewayArn;
        this.host = builder.host;
        this.password = builder.password;
        this.username = builder.username;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String host() {
        return this.host;
    }

    public final String password() {
        return this.password;
    }

    public final String username() {
        return this.username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestHypervisorConfigurationRequest)) {
            return false;
        }
        TestHypervisorConfigurationRequest other = (TestHypervisorConfigurationRequest)((Object)obj);
        return Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.host(), other.host()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.username(), other.username());
    }

    public final String toString() {
        return ToString.builder((String)"TestHypervisorConfigurationRequest").add("GatewayArn", (Object)this.gatewayArn()).add("Host", (Object)this.host()).add("Password", (Object)(this.password() == null ? null : "*** Sensitive Data Redacted ***")).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TestHypervisorConfigurationRequest, T> g) {
        return obj -> g.apply((TestHypervisorConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupGatewayRequest.BuilderImpl
    implements Builder {
        private String gatewayArn;
        private String host;
        private String password;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(TestHypervisorConfigurationRequest model) {
            super(model);
            this.gatewayArn(model.gatewayArn);
            this.host(model.host);
            this.password(model.password);
            this.username(model.username);
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getHost() {
            return this.host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getPassword() {
            return this.password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestHypervisorConfigurationRequest build() {
            return new TestHypervisorConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BackupGatewayRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestHypervisorConfigurationRequest> {
        public Builder gatewayArn(String var1);

        public Builder host(String var1);

        public Builder password(String var1);

        public Builder username(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

