/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscalingplans.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceNamespace {
    AUTOSCALING("autoscaling"),
    ECS("ecs"),
    EC2("ec2"),
    RDS("rds"),
    DYNAMODB("dynamodb"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceNamespace> VALUE_MAP;
    private final String value;

    private ServiceNamespace(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceNamespace fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceNamespace> knownValues() {
        EnumSet<ServiceNamespace> knownValues = EnumSet.allOf(ServiceNamespace.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceNamespace.class, ServiceNamespace::toString);
    }
}

