/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.internal.UserAgentUtils;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeInstanceRefreshesResponse;

public class DescribeInstanceRefreshesPublisher
implements SdkPublisher<DescribeInstanceRefreshesResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeInstanceRefreshesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInstanceRefreshesPublisher(AutoScalingAsyncClient client, DescribeInstanceRefreshesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInstanceRefreshesPublisher(AutoScalingAsyncClient client, DescribeInstanceRefreshesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInstanceRefreshesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInstanceRefreshesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeInstanceRefreshesResponseFetcher
    implements AsyncPageFetcher<DescribeInstanceRefreshesResponse> {
        private DescribeInstanceRefreshesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceRefreshesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInstanceRefreshesResponse> nextPage(DescribeInstanceRefreshesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceRefreshesPublisher.this.client.describeInstanceRefreshes(DescribeInstanceRefreshesPublisher.this.firstRequest);
            }
            return DescribeInstanceRefreshesPublisher.this.client.describeInstanceRefreshes((DescribeInstanceRefreshesRequest)((Object)DescribeInstanceRefreshesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

