/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerTargetGroupState;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerTargetGroupStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoadBalancerTargetGroupsResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
    private static final SdkField<List<LoadBalancerTargetGroupState>> LOAD_BALANCER_TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LoadBalancerTargetGroups").getter(DescribeLoadBalancerTargetGroupsResponse.getter(DescribeLoadBalancerTargetGroupsResponse::loadBalancerTargetGroups)).setter(DescribeLoadBalancerTargetGroupsResponse.setter(Builder::loadBalancerTargetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerTargetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoadBalancerTargetGroupState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLoadBalancerTargetGroupsResponse.getter(DescribeLoadBalancerTargetGroupsResponse::nextToken)).setter(DescribeLoadBalancerTargetGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_TARGET_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LoadBalancerTargetGroups", LOAD_BALANCER_TARGET_GROUPS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;
    private final String nextToken;

    private DescribeLoadBalancerTargetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLoadBalancerTargetGroups() {
        return this.loadBalancerTargetGroups != null && !(this.loadBalancerTargetGroups instanceof SdkAutoConstructList);
    }

    public final List<LoadBalancerTargetGroupState> loadBalancerTargetGroups() {
        return this.loadBalancerTargetGroups;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLoadBalancerTargetGroups() ? this.loadBalancerTargetGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerTargetGroupsResponse)) {
            return false;
        }
        DescribeLoadBalancerTargetGroupsResponse other = (DescribeLoadBalancerTargetGroupsResponse)((Object)obj);
        return this.hasLoadBalancerTargetGroups() == other.hasLoadBalancerTargetGroups() && Objects.equals(this.loadBalancerTargetGroups(), other.loadBalancerTargetGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLoadBalancerTargetGroupsResponse").add("LoadBalancerTargetGroups", this.hasLoadBalancerTargetGroups() ? this.loadBalancerTargetGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerTargetGroups": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerTargetGroups()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBalancerTargetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeLoadBalancerTargetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<LoadBalancerTargetGroupState> loadBalancerTargetGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerTargetGroupsResponse model) {
            super(model);
            this.loadBalancerTargetGroups(model.loadBalancerTargetGroups);
            this.nextToken(model.nextToken);
        }

        public final List<LoadBalancerTargetGroupState.Builder> getLoadBalancerTargetGroups() {
            List<LoadBalancerTargetGroupState.Builder> result = LoadBalancerTargetGroupStatesCopier.copyToBuilder(this.loadBalancerTargetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState.BuilderImpl> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copyFromBuilder(loadBalancerTargetGroups);
        }

        @Override
        public final Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copy(loadBalancerTargetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState ... loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(Consumer<LoadBalancerTargetGroupState.Builder> ... loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups(Stream.of(loadBalancerTargetGroups).map(c -> (LoadBalancerTargetGroupState)((LoadBalancerTargetGroupState.Builder)LoadBalancerTargetGroupState.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeLoadBalancerTargetGroupsResponse build() {
            return new DescribeLoadBalancerTargetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
        public Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> var1);

        public Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState ... var1);

        public Builder loadBalancerTargetGroups(Consumer<LoadBalancerTargetGroupState.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

