/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.auditmanager.AuditManagerAsyncClient;
import software.amazon.awssdk.services.auditmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest;
import software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse;

public class GetDelegationsPublisher
implements SdkPublisher<GetDelegationsResponse> {
    private final AuditManagerAsyncClient client;
    private final GetDelegationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetDelegationsPublisher(AuditManagerAsyncClient client, GetDelegationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetDelegationsPublisher(AuditManagerAsyncClient client, GetDelegationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetDelegationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetDelegationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetDelegationsResponseFetcher
    implements AsyncPageFetcher<GetDelegationsResponse> {
        private GetDelegationsResponseFetcher() {
        }

        public boolean hasNextPage(GetDelegationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetDelegationsResponse> nextPage(GetDelegationsResponse previousPage) {
            if (previousPage == null) {
                return GetDelegationsPublisher.this.client.getDelegations(GetDelegationsPublisher.this.firstRequest);
            }
            return GetDelegationsPublisher.this.client.getDelegations((GetDelegationsRequest)((Object)GetDelegationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

