/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ChannelNamespace;
import software.amazon.awssdk.services.appsync.model.ListChannelNamespacesRequest;
import software.amazon.awssdk.services.appsync.model.ListChannelNamespacesResponse;

public class ListChannelNamespacesIterable
implements SdkIterable<ListChannelNamespacesResponse> {
    private final AppSyncClient client;
    private final ListChannelNamespacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelNamespacesIterable(AppSyncClient client, ListChannelNamespacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListChannelNamespacesResponseFetcher();
    }

    public Iterator<ListChannelNamespacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChannelNamespace> channelNamespaces() {
        Function<ListChannelNamespacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelNamespaces() != null) {
                return response.channelNamespaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListChannelNamespacesResponseFetcher
    implements SyncPageFetcher<ListChannelNamespacesResponse> {
        private ListChannelNamespacesResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelNamespacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListChannelNamespacesResponse nextPage(ListChannelNamespacesResponse previousPage) {
            if (previousPage == null) {
                return ListChannelNamespacesIterable.this.client.listChannelNamespaces(ListChannelNamespacesIterable.this.firstRequest);
            }
            return ListChannelNamespacesIterable.this.client.listChannelNamespaces((ListChannelNamespacesRequest)((Object)ListChannelNamespacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

