/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppBlockBuilderAppBlockAssociationsRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, DescribeAppBlockBuilderAppBlockAssociationsRequest> {
    private static final SdkField<String> APP_BLOCK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppBlockArn").getter(DescribeAppBlockBuilderAppBlockAssociationsRequest.getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::appBlockArn)).setter(DescribeAppBlockBuilderAppBlockAssociationsRequest.setter(Builder::appBlockArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockArn").build()}).build();
    private static final SdkField<String> APP_BLOCK_BUILDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppBlockBuilderName").getter(DescribeAppBlockBuilderAppBlockAssociationsRequest.getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::appBlockBuilderName)).setter(DescribeAppBlockBuilderAppBlockAssociationsRequest.setter(Builder::appBlockBuilderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockBuilderName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeAppBlockBuilderAppBlockAssociationsRequest.getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::maxResults)).setter(DescribeAppBlockBuilderAppBlockAssociationsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAppBlockBuilderAppBlockAssociationsRequest.getter(DescribeAppBlockBuilderAppBlockAssociationsRequest::nextToken)).setter(DescribeAppBlockBuilderAppBlockAssociationsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCK_ARN_FIELD, APP_BLOCK_BUILDER_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AppBlockArn", APP_BLOCK_ARN_FIELD);
            this.put("AppBlockBuilderName", APP_BLOCK_BUILDER_NAME_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String appBlockArn;
    private final String appBlockBuilderName;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeAppBlockBuilderAppBlockAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.appBlockArn = builder.appBlockArn;
        this.appBlockBuilderName = builder.appBlockBuilderName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String appBlockArn() {
        return this.appBlockArn;
    }

    public final String appBlockBuilderName() {
        return this.appBlockBuilderName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appBlockArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appBlockBuilderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppBlockBuilderAppBlockAssociationsRequest)) {
            return false;
        }
        DescribeAppBlockBuilderAppBlockAssociationsRequest other = (DescribeAppBlockBuilderAppBlockAssociationsRequest)((Object)obj);
        return Objects.equals(this.appBlockArn(), other.appBlockArn()) && Objects.equals(this.appBlockBuilderName(), other.appBlockBuilderName()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAppBlockBuilderAppBlockAssociationsRequest").add("AppBlockArn", (Object)this.appBlockArn()).add("AppBlockBuilderName", (Object)this.appBlockBuilderName()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppBlockArn": {
                return Optional.ofNullable(clazz.cast(this.appBlockArn()));
            }
            case "AppBlockBuilderName": {
                return Optional.ofNullable(clazz.cast(this.appBlockBuilderName()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppBlockBuilderAppBlockAssociationsRequest, T> g) {
        return obj -> g.apply((DescribeAppBlockBuilderAppBlockAssociationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String appBlockArn;
        private String appBlockBuilderName;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppBlockBuilderAppBlockAssociationsRequest model) {
            super(model);
            this.appBlockArn(model.appBlockArn);
            this.appBlockBuilderName(model.appBlockBuilderName);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAppBlockArn() {
            return this.appBlockArn;
        }

        public final void setAppBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
        }

        @Override
        public final Builder appBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        public final String getAppBlockBuilderName() {
            return this.appBlockBuilderName;
        }

        public final void setAppBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
        }

        @Override
        public final Builder appBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppBlockBuilderAppBlockAssociationsRequest build() {
            return new DescribeAppBlockBuilderAppBlockAssociationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppBlockBuilderAppBlockAssociationsRequest> {
        public Builder appBlockArn(String var1);

        public Builder appBlockBuilderName(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

