/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.PlatformType;
import software.amazon.awssdk.services.appstream.model.PlatformsCopier;
import software.amazon.awssdk.services.appstream.model.S3Location;
import software.amazon.awssdk.services.appstream.model.StringListCopier;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateApplicationRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateApplicationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateApplicationRequest.getter(CreateApplicationRequest::name)).setter(CreateApplicationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateApplicationRequest.getter(CreateApplicationRequest::displayName)).setter(CreateApplicationRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateApplicationRequest.getter(CreateApplicationRequest::description)).setter(CreateApplicationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<S3Location> ICON_S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IconS3Location").getter(CreateApplicationRequest.getter(CreateApplicationRequest::iconS3Location)).setter(CreateApplicationRequest.setter(Builder::iconS3Location)).constructor(S3Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconS3Location").build()}).build();
    private static final SdkField<String> LAUNCH_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchPath").getter(CreateApplicationRequest.getter(CreateApplicationRequest::launchPath)).setter(CreateApplicationRequest.setter(Builder::launchPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPath").build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkingDirectory").getter(CreateApplicationRequest.getter(CreateApplicationRequest::workingDirectory)).setter(CreateApplicationRequest.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkingDirectory").build()}).build();
    private static final SdkField<String> LAUNCH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchParameters").getter(CreateApplicationRequest.getter(CreateApplicationRequest::launchParameters)).setter(CreateApplicationRequest.setter(Builder::launchParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchParameters").build()}).build();
    private static final SdkField<List<String>> PLATFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Platforms").getter(CreateApplicationRequest.getter(CreateApplicationRequest::platformsAsStrings)).setter(CreateApplicationRequest.setter(Builder::platformsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platforms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCE_FAMILIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceFamilies").getter(CreateApplicationRequest.getter(CreateApplicationRequest::instanceFamilies)).setter(CreateApplicationRequest.setter(Builder::instanceFamilies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamilies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APP_BLOCK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppBlockArn").getter(CreateApplicationRequest.getter(CreateApplicationRequest::appBlockArn)).setter(CreateApplicationRequest.setter(Builder::appBlockArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateApplicationRequest.getter(CreateApplicationRequest::tags)).setter(CreateApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, ICON_S3_LOCATION_FIELD, LAUNCH_PATH_FIELD, WORKING_DIRECTORY_FIELD, LAUNCH_PARAMETERS_FIELD, PLATFORMS_FIELD, INSTANCE_FAMILIES_FIELD, APP_BLOCK_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("DisplayName", DISPLAY_NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("IconS3Location", ICON_S3_LOCATION_FIELD);
            this.put("LaunchPath", LAUNCH_PATH_FIELD);
            this.put("WorkingDirectory", WORKING_DIRECTORY_FIELD);
            this.put("LaunchParameters", LAUNCH_PARAMETERS_FIELD);
            this.put("Platforms", PLATFORMS_FIELD);
            this.put("InstanceFamilies", INSTANCE_FAMILIES_FIELD);
            this.put("AppBlockArn", APP_BLOCK_ARN_FIELD);
            this.put("Tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String displayName;
    private final String description;
    private final S3Location iconS3Location;
    private final String launchPath;
    private final String workingDirectory;
    private final String launchParameters;
    private final List<String> platforms;
    private final List<String> instanceFamilies;
    private final String appBlockArn;
    private final Map<String, String> tags;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.iconS3Location = builder.iconS3Location;
        this.launchPath = builder.launchPath;
        this.workingDirectory = builder.workingDirectory;
        this.launchParameters = builder.launchParameters;
        this.platforms = builder.platforms;
        this.instanceFamilies = builder.instanceFamilies;
        this.appBlockArn = builder.appBlockArn;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String description() {
        return this.description;
    }

    public final S3Location iconS3Location() {
        return this.iconS3Location;
    }

    public final String launchPath() {
        return this.launchPath;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final String launchParameters() {
        return this.launchParameters;
    }

    public final List<PlatformType> platforms() {
        return PlatformsCopier.copyStringToEnum(this.platforms);
    }

    public final boolean hasPlatforms() {
        return this.platforms != null && !(this.platforms instanceof SdkAutoConstructList);
    }

    public final List<String> platformsAsStrings() {
        return this.platforms;
    }

    public final boolean hasInstanceFamilies() {
        return this.instanceFamilies != null && !(this.instanceFamilies instanceof SdkAutoConstructList);
    }

    public final List<String> instanceFamilies() {
        return this.instanceFamilies;
    }

    public final String appBlockArn() {
        return this.appBlockArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatforms() ? this.platformsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceFamilies() ? this.instanceFamilies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appBlockArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.iconS3Location(), other.iconS3Location()) && Objects.equals(this.launchPath(), other.launchPath()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.launchParameters(), other.launchParameters()) && this.hasPlatforms() == other.hasPlatforms() && Objects.equals(this.platformsAsStrings(), other.platformsAsStrings()) && this.hasInstanceFamilies() == other.hasInstanceFamilies() && Objects.equals(this.instanceFamilies(), other.instanceFamilies()) && Objects.equals(this.appBlockArn(), other.appBlockArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateApplicationRequest").add("Name", (Object)this.name()).add("DisplayName", (Object)this.displayName()).add("Description", (Object)this.description()).add("IconS3Location", (Object)this.iconS3Location()).add("LaunchPath", (Object)this.launchPath()).add("WorkingDirectory", (Object)this.workingDirectory()).add("LaunchParameters", (Object)this.launchParameters()).add("Platforms", this.hasPlatforms() ? this.platformsAsStrings() : null).add("InstanceFamilies", this.hasInstanceFamilies() ? this.instanceFamilies() : null).add("AppBlockArn", (Object)this.appBlockArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IconS3Location": {
                return Optional.ofNullable(clazz.cast(this.iconS3Location()));
            }
            case "LaunchPath": {
                return Optional.ofNullable(clazz.cast(this.launchPath()));
            }
            case "WorkingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "LaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.launchParameters()));
            }
            case "Platforms": {
                return Optional.ofNullable(clazz.cast(this.platformsAsStrings()));
            }
            case "InstanceFamilies": {
                return Optional.ofNullable(clazz.cast(this.instanceFamilies()));
            }
            case "AppBlockArn": {
                return Optional.ofNullable(clazz.cast(this.appBlockArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String displayName;
        private String description;
        private S3Location iconS3Location;
        private String launchPath;
        private String workingDirectory;
        private String launchParameters;
        private List<String> platforms = DefaultSdkAutoConstructList.getInstance();
        private List<String> instanceFamilies = DefaultSdkAutoConstructList.getInstance();
        private String appBlockArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            this.name(model.name);
            this.displayName(model.displayName);
            this.description(model.description);
            this.iconS3Location(model.iconS3Location);
            this.launchPath(model.launchPath);
            this.workingDirectory(model.workingDirectory);
            this.launchParameters(model.launchParameters);
            this.platformsWithStrings(model.platforms);
            this.instanceFamilies(model.instanceFamilies);
            this.appBlockArn(model.appBlockArn);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final S3Location.Builder getIconS3Location() {
            return this.iconS3Location != null ? this.iconS3Location.toBuilder() : null;
        }

        public final void setIconS3Location(S3Location.BuilderImpl iconS3Location) {
            this.iconS3Location = iconS3Location != null ? iconS3Location.build() : null;
        }

        @Override
        public final Builder iconS3Location(S3Location iconS3Location) {
            this.iconS3Location = iconS3Location;
            return this;
        }

        public final String getLaunchPath() {
            return this.launchPath;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final String getLaunchParameters() {
            return this.launchParameters;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final Collection<String> getPlatforms() {
            if (this.platforms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platforms;
        }

        public final void setPlatforms(Collection<String> platforms) {
            this.platforms = PlatformsCopier.copy(platforms);
        }

        @Override
        public final Builder platformsWithStrings(Collection<String> platforms) {
            this.platforms = PlatformsCopier.copy(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformsWithStrings(String ... platforms) {
            this.platformsWithStrings(Arrays.asList(platforms));
            return this;
        }

        @Override
        public final Builder platforms(Collection<PlatformType> platforms) {
            this.platforms = PlatformsCopier.copyEnumToString(platforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platforms(PlatformType ... platforms) {
            this.platforms(Arrays.asList(platforms));
            return this;
        }

        public final Collection<String> getInstanceFamilies() {
            if (this.instanceFamilies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceFamilies;
        }

        public final void setInstanceFamilies(Collection<String> instanceFamilies) {
            this.instanceFamilies = StringListCopier.copy(instanceFamilies);
        }

        @Override
        public final Builder instanceFamilies(Collection<String> instanceFamilies) {
            this.instanceFamilies = StringListCopier.copy(instanceFamilies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFamilies(String ... instanceFamilies) {
            this.instanceFamilies(Arrays.asList(instanceFamilies));
            return this;
        }

        public final String getAppBlockArn() {
            return this.appBlockArn;
        }

        public final void setAppBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
        }

        @Override
        public final Builder appBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateApplicationRequest> {
        public Builder name(String var1);

        public Builder displayName(String var1);

        public Builder description(String var1);

        public Builder iconS3Location(S3Location var1);

        default public Builder iconS3Location(Consumer<S3Location.Builder> iconS3Location) {
            return this.iconS3Location((S3Location)((S3Location.Builder)S3Location.builder().applyMutation(iconS3Location)).build());
        }

        public Builder launchPath(String var1);

        public Builder workingDirectory(String var1);

        public Builder launchParameters(String var1);

        public Builder platformsWithStrings(Collection<String> var1);

        public Builder platformsWithStrings(String ... var1);

        public Builder platforms(Collection<PlatformType> var1);

        public Builder platforms(PlatformType ... var1);

        public Builder instanceFamilies(Collection<String> var1);

        public Builder instanceFamilies(String ... var1);

        public Builder appBlockArn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

