/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshAsyncClient;
import software.amazon.awssdk.services.appmesh.internal.UserAgentUtils;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualRoutersResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualRouterRef;

public class ListVirtualRoutersPublisher
implements SdkPublisher<ListVirtualRoutersResponse> {
    private final AppMeshAsyncClient client;
    private final ListVirtualRoutersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualRoutersPublisher(AppMeshAsyncClient client, ListVirtualRoutersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualRoutersPublisher(AppMeshAsyncClient client, ListVirtualRoutersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualRoutersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualRoutersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VirtualRouterRef> virtualRouters() {
        Function<ListVirtualRoutersResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualRouters() != null) {
                return response.virtualRouters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVirtualRoutersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVirtualRoutersResponseFetcher
    implements AsyncPageFetcher<ListVirtualRoutersResponse> {
        private ListVirtualRoutersResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualRoutersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVirtualRoutersResponse> nextPage(ListVirtualRoutersResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualRoutersPublisher.this.client.listVirtualRouters(ListVirtualRoutersPublisher.this.firstRequest);
            }
            return ListVirtualRoutersPublisher.this.client.listVirtualRouters((ListVirtualRoutersRequest)((Object)ListVirtualRoutersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

