/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appmesh.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appmesh.AppMeshAsyncClient;
import software.amazon.awssdk.services.appmesh.internal.UserAgentUtils;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysRequest;
import software.amazon.awssdk.services.appmesh.model.ListVirtualGatewaysResponse;
import software.amazon.awssdk.services.appmesh.model.VirtualGatewayRef;

public class ListVirtualGatewaysPublisher
implements SdkPublisher<ListVirtualGatewaysResponse> {
    private final AppMeshAsyncClient client;
    private final ListVirtualGatewaysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVirtualGatewaysPublisher(AppMeshAsyncClient client, ListVirtualGatewaysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVirtualGatewaysPublisher(AppMeshAsyncClient client, ListVirtualGatewaysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVirtualGatewaysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVirtualGatewaysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VirtualGatewayRef> virtualGateways() {
        Function<ListVirtualGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.virtualGateways() != null) {
                return response.virtualGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVirtualGatewaysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVirtualGatewaysResponseFetcher
    implements AsyncPageFetcher<ListVirtualGatewaysResponse> {
        private ListVirtualGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(ListVirtualGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVirtualGatewaysResponse> nextPage(ListVirtualGatewaysResponse previousPage) {
            if (previousPage == null) {
                return ListVirtualGatewaysPublisher.this.client.listVirtualGateways(ListVirtualGatewaysPublisher.this.firstRequest);
            }
            return ListVirtualGatewaysPublisher.this.client.listVirtualGateways((ListVirtualGatewaysRequest)((Object)ListVirtualGatewaysPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

