/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationinsights.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.applicationinsights.model.Tier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workload
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workload> {
    private static final SdkField<String> WORKLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadId").getter(Workload.getter(Workload::workloadId)).setter(Workload.setter(Builder::workloadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadId").build()}).build();
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentName").getter(Workload.getter(Workload::componentName)).setter(Workload.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentName").build()}).build();
    private static final SdkField<String> WORKLOAD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadName").getter(Workload.getter(Workload::workloadName)).setter(Workload.setter(Builder::workloadName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadName").build()}).build();
    private static final SdkField<String> TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tier").getter(Workload.getter(Workload::tierAsString)).setter(Workload.setter(Builder::tier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tier").build()}).build();
    private static final SdkField<String> WORKLOAD_REMARKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkloadRemarks").getter(Workload.getter(Workload::workloadRemarks)).setter(Workload.setter(Builder::workloadRemarks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkloadRemarks").build()}).build();
    private static final SdkField<Boolean> MISSING_WORKLOAD_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MissingWorkloadConfig").getter(Workload.getter(Workload::missingWorkloadConfig)).setter(Workload.setter(Builder::missingWorkloadConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingWorkloadConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ID_FIELD, COMPONENT_NAME_FIELD, WORKLOAD_NAME_FIELD, TIER_FIELD, WORKLOAD_REMARKS_FIELD, MISSING_WORKLOAD_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WorkloadId", WORKLOAD_ID_FIELD);
            this.put("ComponentName", COMPONENT_NAME_FIELD);
            this.put("WorkloadName", WORKLOAD_NAME_FIELD);
            this.put("Tier", TIER_FIELD);
            this.put("WorkloadRemarks", WORKLOAD_REMARKS_FIELD);
            this.put("MissingWorkloadConfig", MISSING_WORKLOAD_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String workloadId;
    private final String componentName;
    private final String workloadName;
    private final String tier;
    private final String workloadRemarks;
    private final Boolean missingWorkloadConfig;

    private Workload(BuilderImpl builder) {
        this.workloadId = builder.workloadId;
        this.componentName = builder.componentName;
        this.workloadName = builder.workloadName;
        this.tier = builder.tier;
        this.workloadRemarks = builder.workloadRemarks;
        this.missingWorkloadConfig = builder.missingWorkloadConfig;
    }

    public final String workloadId() {
        return this.workloadId;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String workloadName() {
        return this.workloadName;
    }

    public final Tier tier() {
        return Tier.fromValue(this.tier);
    }

    public final String tierAsString() {
        return this.tier;
    }

    public final String workloadRemarks() {
        return this.workloadRemarks;
    }

    public final Boolean missingWorkloadConfig() {
        return this.missingWorkloadConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadRemarks());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingWorkloadConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workload)) {
            return false;
        }
        Workload other = (Workload)obj;
        return Objects.equals(this.workloadId(), other.workloadId()) && Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.workloadName(), other.workloadName()) && Objects.equals(this.tierAsString(), other.tierAsString()) && Objects.equals(this.workloadRemarks(), other.workloadRemarks()) && Objects.equals(this.missingWorkloadConfig(), other.missingWorkloadConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Workload").add("WorkloadId", (Object)this.workloadId()).add("ComponentName", (Object)this.componentName()).add("WorkloadName", (Object)this.workloadName()).add("Tier", (Object)this.tierAsString()).add("WorkloadRemarks", (Object)this.workloadRemarks()).add("MissingWorkloadConfig", (Object)this.missingWorkloadConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkloadId": {
                return Optional.ofNullable(clazz.cast(this.workloadId()));
            }
            case "ComponentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "WorkloadName": {
                return Optional.ofNullable(clazz.cast(this.workloadName()));
            }
            case "Tier": {
                return Optional.ofNullable(clazz.cast(this.tierAsString()));
            }
            case "WorkloadRemarks": {
                return Optional.ofNullable(clazz.cast(this.workloadRemarks()));
            }
            case "MissingWorkloadConfig": {
                return Optional.ofNullable(clazz.cast(this.missingWorkloadConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Workload, T> g) {
        return obj -> g.apply((Workload)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workloadId;
        private String componentName;
        private String workloadName;
        private String tier;
        private String workloadRemarks;
        private Boolean missingWorkloadConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Workload model) {
            this.workloadId(model.workloadId);
            this.componentName(model.componentName);
            this.workloadName(model.workloadName);
            this.tier(model.tier);
            this.workloadRemarks(model.workloadRemarks);
            this.missingWorkloadConfig(model.missingWorkloadConfig);
        }

        public final String getWorkloadId() {
            return this.workloadId;
        }

        public final void setWorkloadId(String workloadId) {
            this.workloadId = workloadId;
        }

        @Override
        public final Builder workloadId(String workloadId) {
            this.workloadId = workloadId;
            return this;
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getWorkloadName() {
            return this.workloadName;
        }

        public final void setWorkloadName(String workloadName) {
            this.workloadName = workloadName;
        }

        @Override
        public final Builder workloadName(String workloadName) {
            this.workloadName = workloadName;
            return this;
        }

        public final String getTier() {
            return this.tier;
        }

        public final void setTier(String tier) {
            this.tier = tier;
        }

        @Override
        public final Builder tier(String tier) {
            this.tier = tier;
            return this;
        }

        @Override
        public final Builder tier(Tier tier) {
            this.tier(tier == null ? null : tier.toString());
            return this;
        }

        public final String getWorkloadRemarks() {
            return this.workloadRemarks;
        }

        public final void setWorkloadRemarks(String workloadRemarks) {
            this.workloadRemarks = workloadRemarks;
        }

        @Override
        public final Builder workloadRemarks(String workloadRemarks) {
            this.workloadRemarks = workloadRemarks;
            return this;
        }

        public final Boolean getMissingWorkloadConfig() {
            return this.missingWorkloadConfig;
        }

        public final void setMissingWorkloadConfig(Boolean missingWorkloadConfig) {
            this.missingWorkloadConfig = missingWorkloadConfig;
        }

        @Override
        public final Builder missingWorkloadConfig(Boolean missingWorkloadConfig) {
            this.missingWorkloadConfig = missingWorkloadConfig;
            return this;
        }

        public Workload build() {
            return new Workload(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workload> {
        public Builder workloadId(String var1);

        public Builder componentName(String var1);

        public Builder workloadName(String var1);

        public Builder tier(String var1);

        public Builder tier(Tier var1);

        public Builder workloadRemarks(String var1);

        public Builder missingWorkloadConfig(Boolean var1);
    }
}

